package com.yizhi.application.report.summary;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.statistics.application.entity.Report;
import com.yizhi.statistics.application.entity.ReportVisibleRange;
import com.yizhi.statistics.application.feign.ReportClient;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.plugins.Page;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(tags = "平台报告", description = "平台报告-管理端")
@RestController
@RequestMapping("/manage/report")
public class ReportController {

	@Autowired
	private ReportClient reportClient;

	@PostMapping("/update")
	@ApiOperation(value = "平台报告修改")
	public Response<String> update(@ApiParam(name = "report", value = "需要传入将修改的对象全部信息") @RequestBody Report report) {
		try {
			Report update = reportClient.update(report);
			return Response.ok();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return Response.fail(Constants.MSG_BIZ_FAIL);
		}
	}

	@GetMapping("/up")
	@ApiOperation(value = "平台报告上架")
	public Response<String> up(@ApiParam(name = "reportId", value = "报告id") @RequestParam("reportId") Long reportId) {
		try {
			Boolean up = reportClient.up(reportId);
			if (up) {
				return Response.ok();
			} else {
				return Response.fail(Constants.MSG_BIZ_FAIL);
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return Response.fail(Constants.MSG_BIZ_FAIL);
		}
	}

	@GetMapping("/down")
	@ApiOperation(value = "平台报告下架")
	public Response<String> down(@ApiParam(name = "reportId", value = "报告id") @RequestParam("reportId") Long reportId) {
		try {
			Boolean up = reportClient.down(reportId);
			if (up) {
				return Response.ok();
			} else {
				return Response.fail(Constants.MSG_BIZ_FAIL);
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return Response.fail(Constants.MSG_BIZ_FAIL);
		}
	}

	@PostMapping("/authorize/insert")
	@ApiOperation(value = "平台报告可见范围新增")
	public Response<String> insertReportVisibleRanges(
			@ApiParam(name = "平台报告可见范围", value = "需传reportId、relationId、type") @RequestBody List<ReportVisibleRange> reportVisibleRanges) {
		try {
			Boolean b = reportClient.insertReportVisibleRanges(reportVisibleRanges);
			if (b) {
				return Response.ok();
			} else {
				return Response.fail(Constants.MSG_BIZ_FAIL);
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return Response.fail(Constants.MSG_BIZ_FAIL);
		}
	}

	@GetMapping("/list")
	@ApiOperation(value = "平台报告列表", response = Report.class)
	public Response<Page<Report>> list(
			@ApiParam(name = "pageSize", value = "分页大小,默认10", required = true) @RequestParam(name = "pageSize", defaultValue = "1") Integer pageSize,
			@ApiParam(name = "pageNo", value = "分页跳转页数，默认第一页", required = true) @RequestParam(name = "pageNo", defaultValue = "10") Integer pageNo,
			@ApiParam(name = "type", value = "状态，0下架 1上架 2预定上架 3全部，默认全部") @RequestParam(name = "type", defaultValue = "3") Integer type,
			@ApiParam(name = "kwd", value = "报告关键字") @RequestParam("kwd") String kwd) {
		try {
			RequestContext context = ContextHolder.get();
			Page<Report> page = reportClient.list(pageSize, pageNo, type, context.getSiteId(), context.getCompanyId(),
					kwd);
			return Response.ok(page);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return Response.fail(Constants.MSG_BIZ_FAIL);
		}
	}

	@GetMapping("/VisibleRange")
	@ApiOperation(value = "指定平台报告可见范围", response = ReportVisibleRange.class)
	public Response<List<ReportVisibleRange>> VisibleRange(
			@ApiParam(name = "reportId", value = "报告id") @RequestParam("reportId") Long reportId) {
		try {
			List<ReportVisibleRange> list = reportClient.VisibleRange(reportId);
			return Response.ok(list);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return Response.fail(Constants.MSG_BIZ_FAIL);
		}
	}

	@PostMapping("/relation/list")
	public Response<List<Report>> relationList(@RequestBody List<String> ids) {
		try {
			List<Long> reportIds = ids.stream().map(Long::valueOf).collect(Collectors.toList());
			List<Report> list = reportClient.relationList(reportIds);
			return Response.ok(list);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return Response.fail(Constants.MSG_BIZ_FAIL);
		}
	}
}
