package com.yizhi.application.util;

import com.yizhi.application.course.constant.UtilConstants;
import com.yizhi.application.course.util.WebUpConvert;
import com.yizhi.comment.application.feign.PdfPagesClient;
import com.yizhi.comment.application.vo.PdfVO;
import com.yizhi.comment.application.vo.domain.PdfPagesVo;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.core.application.file.util.OssUpload;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Component
public class PdfPagesAsynchronizationDeal extends AbstractDefaultTask<String, Map<String, Object>> {

    @Autowired
    WebUpConvert webUpConvert;

    @Autowired
    PdfPagesClient pdfPagesClient;

    @Value("${pc.host.url}")
    String pcHostUrl;
    
    @Override
    protected String execute(Map<String, Object> stringObjectMap) {

        TaskContext taskContext = null;
        PdfVO pdfVO = null;
        try {
        	pdfVO = (PdfVO) stringObjectMap.get("pdf");
        	String name= pdfVO.getOriginalFile().substring(0, pdfVO.getOriginalFile().lastIndexOf("."));
            // 任务id   任务名字   操作人id  操作时间
            taskContext = new TaskContext(System.currentTimeMillis(), name, pdfVO.getCreateById(), new Date(),
            		pdfVO.getSiteId(), pdfVO.getCompanyId());
            working(taskContext);
            String imageDir = webUpConvert.convert(pdfVO.getOriginalFileUrl(), pdfVO.getOriginalFile(), UtilConstants.DOC_PATH, 200, 0, UtilConstants.OPENOFFICE_PATH);
            File dir = new File(imageDir);
            File[] files = dir.listFiles();

            String uploadFile;
            String key;
            List<PdfPagesVo> pdfPages = new ArrayList<PdfPagesVo>();

            if (files.length > 0) {
                for (File file : files) {
                    uploadFile = file.getAbsolutePath();
                    key = name + "/" + System.currentTimeMillis()+"/"+file.getName();
                    OssUpload.upload(uploadFile, key);
                    String  result = pcHostUrl+"/api/v1/buckets/upload/objects/download/?preview=true&prefix="+key;
                    PdfPagesVo pdfPage = new PdfPagesVo();
                    pdfPage.setPdfPage(Integer.parseInt(file.getName().substring(0, file.getName().lastIndexOf("."))));
                    pdfPage.setImageUrl(result);
                    pdfPage.setBizId(pdfVO.getBizId());
                    pdfPage.setBizType(pdfVO.getBizType());
                    pdfPages.add(pdfPage);
                }
                boolean b = pdfPagesClient.save(pdfPages);
                if (b) {
                	success(taskContext, name + "解析成功！", null);
				}else {
					fail(taskContext, pdfVO.getOriginalFileUrl() + "解析失败");
				}
            }
        } catch (Exception e) {
            e.printStackTrace();
            fail(taskContext, pdfVO.getOriginalFileUrl() + "解析失败："+e.getMessage());
        }
        return null;
    }
}
