package com.yizhi.application.Certificate.CertificateUtills;

import com.yizhi.application.Certificate.constant.LogError;
import com.yizhi.application.Certificate.util.MyCertificateUtil;
import com.yizhi.certificate.application.feign.CertificateAppClient;
import com.yizhi.certificate.application.feign.CertificateClient;
import com.yizhi.certificate.application.feign.CertificatePcClient;
import com.yizhi.certificate.application.vo.PushCertificateParam;
import com.yizhi.certificate.application.vo.domain.CertificateVo;
import com.yizhi.certificate.application.vo.domain.TrUserCertificateVo;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.task.AbstractTaskHandler;
import com.yizhi.core.application.task.TaskExecutor;
import com.yizhi.system.application.system.remote.AccountClient;
import com.yizhi.system.application.system.remote.OrganizationClient;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * *
 * 证书异步补发,及生成
 *
 * @param
 * @author dingxiaowei
 * @date 2020/1/9
 * @return
 */
@Component
public class PushCertificateUtil {


    private static final Logger LOGGER = LoggerFactory.getLogger(PushCertificateUtil.class);

    @Autowired
    private TaskExecutor taskExecutor;

    @Autowired
    private CertificatePcClient certificatePcClient;

    @Autowired
    private CertificateClient certificateClient;

    @Autowired
    private OrganizationClient organizationClient;

    @Autowired
    private AccountClient accountClient;

    @Autowired
    private CertificateAppClient certificateAppClient;

    public void pushCertificate(Integer bizdType, Long bizdId, String bizdName, List<Long> certificateIds) {

        RequestContext res = ContextHolder.get();


        taskExecutor.asynExecute(new AbstractTaskHandler() {
            @Override
            public void handle() {

                LOGGER.info("************补发证书bizdType{},bizdId{},certificateIds{}", bizdType, bizdId, certificateIds);

                try {
                    //课程补发
                    if (bizdType == 1 && CollectionUtils.isNotEmpty(certificateIds)) {
                        for (Long certificateId : certificateIds) {
                            PushCertificateParam pushCertificateParam = new PushCertificateParam();
                            pushCertificateParam.setBizdId(bizdId);
                            pushCertificateParam.setBizdName(bizdName);
                            pushCertificateParam.setType(1);
                            pushCertificateParam.setCertificateId(certificateId);
                            pushCertificateParam.setRes(res);
                            //发放证书
                            TrUserCertificateVo trUserCertificate = certificatePcClient.pushCertificate(pushCertificateParam);
                            LOGGER.info("************补发完成/证书已发放", trUserCertificate.getId());

                            if (null != trUserCertificate) {
                                //生成证书
                                if (StringUtils.isBlank(trUserCertificate.getUserImage())) {
                                    String result;

                                    CertificateVo certificate = certificateClient.getCertificate(trUserCertificate.getCertificateId());


                                    com.yizhi.system.application.vo.AccountVO accountVO = null;
                                    try {
                                        accountVO = accountClient.findById(trUserCertificate.getAccountId());
                                    } catch (Exception e) {
                                        e.printStackTrace();
                                    }

                                    //获取全部门集合
                                    List<String> orgNameList = organizationClient.getChiefOrgNames(res.getOrgId(), res.getCompanyId());
                                    if (null == orgNameList) {
                                        orgNameList = new ArrayList<>();
                                    }
                                    Boolean vailTemplate = null != certificate && !org.springframework.util.StringUtils.isEmpty(certificate.getTemplate());
                                    if (vailTemplate) {
                                        result = MyCertificateUtil.generatingCertificateImage(trUserCertificate, certificate.getTemplate(), accountVO, orgNameList);
                                    } else {
                                        result = MyCertificateUtil.generatingCertificateImage(trUserCertificate, "http://fulan-test.oss-cn-hangzhou.aliyuncs.com/cert.zip", accountVO, orgNameList);
                                    }
                                    if (LogError.CERTIFICATE_ANALYSIS_ERROR.equals(result)) {
                                        LOGGER.error("我的证书生成解析失败！");
                                    } else {
                                        trUserCertificate.setUserImage(result);
                                        certificateAppClient.updateTrUserCertificate(trUserCertificate);
                                        LOGGER.info("************证书生成成功", trUserCertificate.getId(), trUserCertificate.getUserImage());
                                    }
                                }
                            }
                        }
                    }

                } catch (Exception e) {
                    LOGGER.error("补发证书异步出现错误", e);
                }
            }
        });

    }

}
