package com.yizhi.application.course.controller;


import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.course.application.feign.CourseClient;
import com.yizhi.course.application.vo.ApiListCourseVo;
import com.yizhi.course.application.vo.FavoriteVo;
import com.yizhi.forum.application.feign.student.StudentPostsClient;
import com.yizhi.forum.application.vo.forum.PostsStudentVo;
import com.yizhi.library.application.feign.StudentCaseClient;
import com.yizhi.library.application.vo.FavoriteVO;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 〈一句话功能简述〉<br>
 * <p>
 * 〈课程收藏 (PC端) 〉
 *
 * @author huangliang
 * @create 2018/12/13
 */
@Api(tags = "学员端( PC端 )-课程收藏相关接口")
@RestController
@RequestMapping("/api/pc/favoritepc")
public class FavoritePcStuController {

    @Autowired
    CourseClient courseClient;
    @Autowired
    StudentCaseClient studentCaseClient;
    @Autowired
    private StudentPostsClient studentPostsClient;


    @ApiOperation(value = "课程收藏", notes = "课程收藏  ( PC 端)")
    @PostMapping("/save")
    public Response savePCFavorite(@RequestBody FavoriteVo favorite) {
        RequestContext context = ContextHolder.get();
        favorite.setAccountId(context.getAccountId());
        Boolean f = courseClient.savePCFavorite(favorite);
        if (f) {
            return Response.ok(f);
        }
        return Response.fail(Constants.MSG_BIZ_FAIL);
    }

    @ApiOperation(value = "取消课程收藏", notes = "取消课程收藏  ( PC 端)")
    @PostMapping("/delete")
    public Response deletePCFavorite(@RequestBody FavoriteVo favorite) {
        RequestContext context = ContextHolder.get();
        favorite.setAccountId(context.getAccountId());
        Boolean f = courseClient.deletePCFavorite(favorite);
        if (f) {
            return Response.ok(f);
        }
        return Response.fail(Constants.MSG_BIZ_FAIL);
    }

    @ApiOperation(value = "课程收藏总数", notes = "课程收藏总数  ( PC 端)")
    @GetMapping("/total")
    public Response getPCMyFavoriteCount() {
        RequestContext context = ContextHolder.get();
        Integer count = courseClient.getPCMyFavoriteCount(context.getAccountId(), context.getCompanyId(), context.getSiteId());
        return Response.ok(count);
    }

    @ApiOperation(value = "课程收藏列表 (分页)", notes = "课程收藏列表  ( PC 端)")
    @GetMapping("/list")
    public Response<Page<ApiListCourseVo>> getPCMyFavoriteList(
            @ApiParam(name = "name", value = "课程名称", required = false) @RequestParam(name = "name", value = "name", required = false) String name,
            @ApiParam(name = "type", value = "type 1:课程，2案例，3：论坛帖子", required = true, defaultValue = "1") @RequestParam(name = "type", required = true, defaultValue = "1") Integer type,
            @ApiParam(name = "pageNo", value = "跳转页数,默认第一页", required = true) @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
            @ApiParam(name = "pageSize", value = "每页条数,默认20条", required = true) @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize
    ) {
        RequestContext context = ContextHolder.get();
        Map<String, Integer> pageMap = new HashMap<String, Integer>();
        Page<ApiListCourseVo> page = new Page<ApiListCourseVo>();
        if (type == 2) {

            Page<FavoriteVO> favorites = studentCaseClient.getFavorites(pageNo, pageSize, name);
            if (CollectionUtils.isNotEmpty(favorites.getRecords())) {
                List<ApiListCourseVo> apiListCourseVos = favorites.getRecords().parallelStream().map(favoriteVO -> {
                    ApiListCourseVo apiListCourseVo = new ApiListCourseVo();
                    apiListCourseVo.setId(favoriteVO.getStudentCaseId() != null ? favoriteVO.getStudentCaseId() : 0L);
                    apiListCourseVo.setName(favoriteVO.getStudentCaseTittle() != null ? favoriteVO.getStudentCaseTittle() : "");
                    apiListCourseVo.setImage(favoriteVO.getStudentCaseLogoUrl() != null ? favoriteVO.getStudentCaseLogoUrl() : "");
                    apiListCourseVo.setAuthor(favoriteVO.getAuthorFullName() != null ? favoriteVO.getAuthorFullName() : "");
                    apiListCourseVo.setLikeNum(favoriteVO.getAdmireNum() != null ? favoriteVO.getAdmireNum() : 0);
                    apiListCourseVo.setStudyNum(favoriteVO.getStudyNum() != null ? favoriteVO.getStudyNum() : 0);
                    apiListCourseVo.setCreateTime(favoriteVO.getSubmitTime());
                    return apiListCourseVo;
                }).collect(Collectors.toList());

                page.setRecords(apiListCourseVos);
                page.setTotal(favorites.getTotal());
                page.setSize(favorites.getSize());
                pageMap.put("pageTotal", favorites.getPages());
            }
        } else if (type == 1) {
            page = courseClient.getPCMyFavoriteList(context.getAccountId(), name, context.getCompanyId(), context.getSiteId(), pageNo, pageSize);
            pageMap.put("pageTotal", page.getPages());
        } else if (type == 3) {
            Page<PostsStudentVo> postsStudentVoPage = studentPostsClient.myPage(2, null, null, null, pageNo, pageSize);
            List<PostsStudentVo> records = postsStudentVoPage.getRecords();
            if (CollectionUtils.isNotEmpty(records)) {
                List<ApiListCourseVo> apiListCourseVos = records.parallelStream().map(a -> {
                    ApiListCourseVo apiListCourseVo = new ApiListCourseVo();
                    apiListCourseVo.setId(a.getId());
                    apiListCourseVo.setName(a.getTitle());
                    apiListCourseVo.setAuthor(a.getAuthorName());
                    apiListCourseVo.setCreateTimeString(a.getCreateTimeString());
                    //是否加精啦
                    apiListCourseVo.setValid(a.getIsHighlight());
                    apiListCourseVo.setClassifyName(a.getPostClassifyName());
                    return apiListCourseVo;
                }).collect(Collectors.toList());

                page.setRecords(apiListCourseVos);
                page.setTotal(postsStudentVoPage.getTotal());
                page.setSize(postsStudentVoPage.getSize());
                pageMap.put("pageTotal", postsStudentVoPage.getPages());
            }
        }
        pageMap.put("pageNo", page.getCurrent());
        pageMap.put("pageSize", page.getSize());
        pageMap.put("total", page.getTotal());

        return Response.ok(page, pageMap);
    }

}
