/**
 * FileName: FavoriteStuController
 * Author:   wenjunlong
 * Date:     2018/4/23 14:18
 * Description: 课程收藏
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.application.course.controller;

import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.course.application.feign.CourseClient;
import com.yizhi.course.application.vo.ApiListCourseVo;
import com.yizhi.course.application.vo.FavoriteVo;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 〈一句话功能简述〉<br> 
 * 〈课程收藏〉
 *
 * @author wenjunlong
 * @create 2018/4/23
 * @since 1.0.0
 */
@Api(tags = "学员端-课程收藏相关接口")
@RestController
@RequestMapping("/api/favorite")
public class FavoriteStuController {

    @Autowired
    CourseClient courseClient;

    @PostMapping("/save")
    public Response saveFavorite(@RequestBody FavoriteVo favorite){
        RequestContext context = ContextHolder.get();
        favorite.setAccountId(context.getAccountId());
        Boolean f = courseClient.saveFavorite(favorite);
        if (f) {
            return Response.ok();
        }
        return Response.fail();
    }

    @PostMapping("/delete")
    public Response deleteFavorite(@RequestBody FavoriteVo favorite){
        RequestContext context = ContextHolder.get();
        favorite.setAccountId(context.getAccountId());
        Boolean f = courseClient.deleteFavorite(favorite);
        if (f) {
            return Response.ok();
        }
        return Response.fail();
    }

    @GetMapping("/total")
    public Response getMyFavoriteCount() {
        RequestContext context = ContextHolder.get();
        Integer count = courseClient.getMyFavoriteCount(context.getAccountId(), context.getCompanyId(), context.getSiteId());
        return Response.ok(count);
    }

    @GetMapping("/list")
    public Response<List<ApiListCourseVo>> getMyFavoriteList(
            @ApiParam(name = "name", value = "课程名称", required = false) @RequestParam(name = "name",value = "name",required = false) String name,
            @ApiParam(name = "pageNo", value = "跳转页数,默认第一页", required = true) @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
            @ApiParam(name = "pageSize", value = "每页条数,默认20条", required = true) @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize
    ) {
        RequestContext context = ContextHolder.get();
        List<ApiListCourseVo> apiListCourseVos = courseClient.getMyFavoriteList(context.getAccountId(),name, context.getCompanyId(), context.getSiteId(),pageNo,pageSize);
        return Response.ok(apiListCourseVos);
    }



}
