package com.yizhi.application.course.controller;


import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.course.application.feign.CommentClient;
import com.yizhi.course.application.vo.CourseGradeVO;
import com.yizhi.util.application.domain.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;



import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@Api(tags = "学员端-课程评分api", description = "学员端-课程评分接口")
@RestController
@RequestMapping("/api/grade")
public class GradeController {
	private static final Logger logger = LoggerFactory.getLogger(GradeController.class);


	@Autowired
	private CommentClient commentClient;

	@ApiOperation(value = "根据前端传入的评分对象新增评分(新增)")
	@PostMapping("/save")
	public Response<String> saveGrade(
			@RequestBody CourseGradeVO courseGrade
//			@ApiParam(name = "account_id", value = "账号id") @RequestParam(name = "account_id") Long accountId,
//			@ApiParam(name = "course_id", value = "课程id") @RequestParam(name = "course_id") Long courseId,
//			@ApiParam(name = "level", value = "评分") @RequestParam(name = "level") Integer level
	) {
		RequestContext context = ContextHolder.get();
		courseGrade.setAccountId(context.getAccountId());
		try {
			if (commentClient.saveGrade(courseGrade) != null) {
				return Response.ok();
			}
			return Response.fail();
		} catch (Exception e) {
			logger.error("", e);
			return Response.fail();
		}
	}

}
