package com.yizhi.application.forum.controller;



import com.yizhi.forum.application.feign.student.StudentPostsFavoriteClient;
import com.yizhi.forum.application.vo.domain.PostsFavoriteVo;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "学员端-帖子收藏接口")
@RestController
@RequestMapping("/student/postsFavorite")
public class StudentPostsFavoriteController {

    private static final Logger LOG = LoggerFactory.getLogger(StudentPostsFavoriteController.class);

    @Autowired
    private StudentPostsFavoriteClient studentPostsFavoriteClient;

    @PostMapping("/save")
    @ApiOperation(value = "学员端收藏帖子")
    public Response<Object> save(@ApiParam("postsFavorite") @RequestBody PostsFavoriteVo postsFavorite) {
        studentPostsFavoriteClient.save(postsFavorite);
        return Response.ok("操作成功！");
    }

    @PostMapping("/deleted")
    @ApiOperation(value = "学员端取消收藏帖子")
    public Response<Object> deleted(@ApiParam("PostsFavorite") @RequestBody PostsFavoriteVo postsFavorite) {

        studentPostsFavoriteClient.deleted(postsFavorite);
        return Response.ok("操作成功！");
    }


}
