package com.yizhi.application.subscribe;

import java.util.List;

import com.yizhi.album.application.feign.AlbumClient;
import com.yizhi.album.application.vo.ApiListAlbumVo;
import com.yizhi.album.application.vo.ApiSearchAlbumVo;
import com.yizhi.comment.application.feign.SubscribeClient;
import com.yizhi.comment.application.vo.domain.SubscribeVo;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.util.application.domain.Response;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.plugins.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;

@Api(tags = "学员端-订阅", description = "订阅接口")
@RestController
@RequestMapping("/api/subcribe")
public class SubscribeController {

	@Autowired
	private SubscribeClient subscribeClient;
	
	@Autowired
	private AlbumClient albumClient;
	
	@GetMapping("/get")
	public Response<SubscribeVo> get(@ApiParam(name = "bizId",value = "业务id")@RequestParam Long bizId,@ApiParam(name = "bizType",value = "业务类型")@RequestParam Integer bizType){
		RequestContext context = ContextHolder.get();
		SubscribeVo subscribe = subscribeClient.get(bizId, bizType, context.getAccountId(), context.getSiteId(), context.getCompanyId());
        return Response.ok(subscribe);
	}
	
	@GetMapping("/update")
	public Response<SubscribeVo> update(@ApiParam(name = "bizId",value = "业务id")@RequestParam Long bizId,@ApiParam(name = "bizType",value = "业务类型")@RequestParam Integer bizType){
		RequestContext context = ContextHolder.get();
		SubscribeVo subscribe = subscribeClient.save(bizId, bizType, context.getAccountId(), context.getSiteId(), context.getCompanyId());
        return Response.ok(subscribe);
	}
	
	@GetMapping("/getMyList")
	public Response getMyList(@ApiParam(name = "bizType",value = "业务类型")@RequestParam Integer bizType,@ApiParam(name = "pageNo",value = "跳转页数 默认第一页")@RequestParam(name = "pageNo",defaultValue = "1") Integer pageNo,
			@ApiParam(name = "pageSize",value = "分页大小")@RequestParam(name = "pageSize",defaultValue = "10") Integer pageSize) {
		RequestContext context = ContextHolder.get();
		Long accountId = context.getAccountId();
		Long siteId = context.getSiteId();
		Long companyId = context.getCompanyId();
		List<Long> list = subscribeClient.getMyList(bizType, accountId, siteId, companyId);
		if (CollectionUtils.isNotEmpty(list)) {
			switch (bizType) {
			//专辑
			case 15:
				ApiSearchAlbumVo vo = new ApiSearchAlbumVo();
				vo.setPageNo(pageNo);
				vo.setPageSize(pageSize);
				vo.setIds(list);
				Page<ApiListAlbumVo> page = albumClient.getMySubscribePage(vo);
				return Response.ok(page);
			}
		}
		return Response.ok();
	}
}
