package com.yizhi.application.album;

import com.yizhi.album.application.feign.AlThemeActivityClient;
import com.yizhi.album.application.feign.AlbumClassifyClient;
import com.yizhi.album.application.vo.AlbumVo;
import com.yizhi.album.application.vo.domain.AlThemeActivity;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.json.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;

@Api(tags = "管理端-专辑活动", description = "专辑活动接口")
@RestController
@RequestMapping("/manage/album/activity")
public class AlThemeAcitivityController {

	private Logger logger = LoggerFactory.getLogger(AlThemeAcitivityController.class);
	
	@Autowired
	private AlThemeActivityClient alThemeActivityClient;
	
	@Autowired
	private AlbumClassifyClient albumClassifyClient;
	
	@ApiOperation(value = "专辑活动保存", notes = "专辑活动保存")
	@PostMapping("/save")
	public Response<String> sava(@RequestBody AlbumVo vo) {
		Boolean b = alThemeActivityClient.sava(vo);
		if (!b) {
			return Response.fail("专辑中主题名称不能重复");
		}
		return Response.ok();
	}
	
	@ApiOperation(value = "专辑活动删除", notes = "专辑活动删除")
	@GetMapping("/delete")
	public Response<String> delete(@ApiParam(name = "id",value = "专辑活动id")@RequestParam(name = "id")Long id) {
		try {
			return Response.ok(alThemeActivityClient.delete(id));
		} catch (Exception e) {
			logger.error("", e);
			return Response.fail("删除失败");
		}
	}
	
	@ApiOperation(value = "专辑活动拖动", notes = "专辑活动拖动排序")
	@PostMapping("/sortActivity")
	public Response<String> sortActivity(@RequestBody String list) {
		List<AlThemeActivity> list1 = JsonUtil.json2List(list, AlThemeActivity.class);
		try {
			logger.info("web端传入要排序的ID列表----------:" + list);
			return Response.ok(alThemeActivityClient.sortActivity(list1));
		} catch (Exception e) {
			logger.error("", e);
			return Response.fail("排序失败");
		}
	}
	
	@ApiOperation(value = "专辑活动定时解锁", notes = "专辑活动定时解锁")
	@PostMapping("/unLock")
	public Response<String> unLock(@RequestBody AlThemeActivity activity) {
		try {
			return Response.ok(alThemeActivityClient.unLock(activity));
		} catch (Exception e) {
			logger.error("", e);
			return Response.fail("设置定时解锁失败");
		}
	}
	
	@ApiOperation(value = "专辑活动列表", notes = "返回专辑活动列表",response = AlbumVo.class)
	@GetMapping("/list")
	public Response<AlbumVo> list(@ApiParam(name = "albumId",value = "专辑主键id")@RequestParam(name = "albumId")Long albumId) {
		try {
			AlbumVo vo = alThemeActivityClient.list(albumId);
			String classifyName = albumClassifyClient.getClassifyName(vo.getClassifyId());
			vo.setClassifyName(classifyName);
			return Response.ok(vo);
		} catch (Exception e) {
			logger.error("", e);
			return Response.fail("专辑活动列表查询失败");
		}
	}
}
