package com.yizhi.application.project.controller;


import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.training.application.feign.TpCommentReplyClient;
import com.yizhi.training.application.vo.domain.TpCommentReplyVo;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 培训项目 - 评论回复 前端控制器
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-27
 */
@Api(tags = "项目评论回复接口")
@RestController
@RequestMapping("/manage/tpCommentReply")
public class TpCommentReplyController {

    private static final Logger LOGGER = LoggerFactory.getLogger(TpCommentReplyController.class);
    
    @Autowired
    TpCommentReplyClient commentReplyClient;

    @GetMapping("/list")
    @ApiOperation(value = "评论回复列表查询", notes = "返回评论列表", response = TpCommentReplyVo.class)
    public Response<Page<TpCommentReplyVo>> replyList(
            @ApiParam(value = "项目评论id", required = true) @RequestParam("commmentId") Long commmentId,
            @ApiParam(name = "pageNo", value = "跳转页数,默认第一页", required = true) @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
            @ApiParam(name = "pageSize", value = "每页条数,默认20条", required = true) @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize) {

        Page<TpCommentReplyVo> page = commentReplyClient.replyList(commmentId, pageNo, pageSize,0);
        return Response.ok(page);
    }

    @GetMapping("/deleteReply")
    @ApiOperation(value = "评论回复删除", response = Boolean.class)
    public Response<Boolean> replyDowm(@ApiParam(value = "回复Id") @RequestParam(value = "replyId") Long replyId) {
        ;
        if (!replyId.equals(null)) {
            if (commentReplyClient.delete(replyId)) {
                return Response.ok("评论回复删除成功！");
            }
        }
        return Response.fail(InternationalEnums.TPCOMMENTREPLYCONTROLLER1.getCode());
    }

    @GetMapping("/up")
    @ApiOperation(value = "回复上架", notes = "返回操作状态")
    public Response up(@RequestParam("id")Long id) {
    	Boolean up = commentReplyClient.up(id);
        if (up) {
            LOGGER.info("回复上架操作成功");
            return Response.ok("回复上架操作成功");
        } else {
            LOGGER.error("回复上架操作失败");
            return Response.fail(InternationalEnums.TPCOMMENTREPLYCONTROLLER2.getCode());
        } 	
    }

    @GetMapping("/down")
    @ApiOperation(value = "回复下架", notes = "返回操作状态")
    public Response down(@RequestParam("id")Long id) {
    	Boolean down = commentReplyClient.down(id);
        if (down) {
            LOGGER.info("回复下架操作成功");
            return Response.ok("回复下架操作成功");
        } else {
            LOGGER.error("回复下架操作失败");
            return Response.fail(InternationalEnums.TPCOMMENTREPLYCONTROLLER3.getCode());
        } 	
    }
}



