//package com.yizhi.application.vote.controller;
//
//import com.yizhi.application.feign.VoteClient;
//import com.yizhi.application.vo.ResponseOptionVO;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.web.bind.annotation.*;
//
//import com.baomidou.mybatisplus.plugins.Page;
//import com.yizhi.application.context.ContextHolder;
//import com.yizhi.application.context.RequestContext;
//import com.yizhi.application.domain.TrVoteOption;
//import com.yizhi.application.feign.VoteOptionClient;
//import com.yizhi.application.util.constant.ReturnCode;
//import com.yizhi.application.util.domain.Response;
//import com.yizhi.application.util.page.PageInfo;
//import com.yizhi.application.vo.PageTrVoteOptionVoteVO;
//import com.yizhi.application.vo.VoteOptionVO;
//import com.yizhi.application.vo.VoteParamVO;
//
//import io.swagger.annotations.Api;
//import io.swagger.annotations.ApiOperation;
//import io.swagger.annotations.ApiParam;
//
///**
// * <p>
// * 投票 前端控制器
// * </p>
// *
// * @author lilingye
// * @since 2018-03-26
// */
//@Api(tags = "投票-投票选项接口")
//@RestController
//@RequestMapping("manage/vote/single/vote/option")
//public class VoteOptionController {
//	private static final Logger LOGGER = LoggerFactory.getLogger(VoteOptionController.class);
//
//	@Autowired
//	private VoteOptionClient voteOptionClient;
//
//	@Autowired
//    private VoteClient voteClient;
//
//	/**
//	 * 新增投票选项
//	 * @param voteOptionVO
//	 */
//	@ApiOperation(value = "新增投票选项", notes = "新增投票选项", response = TrVoteOption.class)
//	@PostMapping("/insert")
//	public Response<String> addVoteOption(@RequestBody VoteOptionVO voteOptionVO){
//
//		// 从上下文中取出用户的相关信息
//		RequestContext context = ContextHolder.get();
//		voteOptionVO.setCreateById(context.getAccountId());
//		voteOptionVO.setCreateByName(context.getAccountName());
//
//		int trVoteOption = voteOptionClient.addVoteOption(voteOptionVO);
//		if (trVoteOption>0) {
//			return Response.ok(ReturnCode.SUCCESS);
//		} else {
//			return  Response.fail(ReturnCode.SAVE_FAIL.getCode(),ReturnCode.SAVE_FAIL.getMsg());
//		}
//	}
//
//
//	/**
//	 * 编辑投票选项
//	 * @param voteOptionVO 投票选项的voteOptionVO
//	 */
//	@ApiOperation(value = "编辑投票选项", notes = "编辑投票选项")
//	@PostMapping("/update")
//	public Response<String> updateVoteOption(@RequestBody VoteOptionVO voteOptionVO ){
//		// 从上下文中获取用户的信息
//		RequestContext context = ContextHolder.get();
//		voteOptionVO.setUpdateById(context.getAccountId());
//		voteOptionVO.setUpdateByName(context.getAccountName());
//		int res = voteOptionClient.updateVoteOption(voteOptionVO);
//		if (res>0) {
//			return Response.ok(ReturnCode.SUCCESS);
//		} else {
//			return Response.fail(ReturnCode.UPDATE_FAIL.getCode(),ReturnCode.UPDATE_FAIL.getMsg());
//		}
//	}
//
//
//
//	/**
//	 * 删除投票选项
//	 * @param paramVO 投票选项的id
//	 */
//	@ApiOperation(value = "删除投票选项", notes = "删除投票选项")
//	@PostMapping("/delete")
//	public Response<String> delVoteOption(
//			@ApiParam("投票选项id") @RequestBody VoteParamVO paramVO ){
//		int res = voteOptionClient.delVoteOption(paramVO);
//		if (res>0) {
//			return Response.ok(ReturnCode.SUCCESS);
//		} else {
//			return Response.fail(ReturnCode.DELETE_FAIL.getCode(),ReturnCode.DELETE_FAIL.getMsg());
//		}
//	}
//
//	/**
//	 * 投票选项排序
//	 * @param paramVO 投票选项的id
//	 */
//	@ApiOperation(value = "投票选项排序", notes = "投票选项排序")
//	@PostMapping("/sort")
//	public Response<String> sortVoteOption(
//			@ApiParam("要移动投票选项id") @RequestBody VoteParamVO paramVO  ){
//		int res = voteOptionClient.sortVoteOption(paramVO);
//		if (res>0) {
//			return Response.ok(ReturnCode.SUCCESS);
//		} else {
//			return Response.fail();
//		}
//
//	}
//
//
//    /**
//     * 投票选项列表
//     * @param voteId 投票id
//     * @param pageInfo 参数
//     * @return
//     */
//	@ApiOperation(value = "投票选项列表", notes = "获取投票选项列表", response = PageTrVoteOptionVoteVO.class)
//	@GetMapping("/list")
//	public Response<ResponseOptionVO> getVoteOptionById(
//			@RequestParam(value="voteId") String voteId, PageInfo pageInfo
//			){
//		Page<TrVoteOption>  page = voteOptionClient.getVoteOptionByVoteId(voteId, pageInfo);
//        Integer optionType = voteClient.viewVote(voteId).getOptionType();
//        ResponseOptionVO responseOptionVO = new ResponseOptionVO();
//        responseOptionVO.setPage(page);
//        responseOptionVO.setOptionType(optionType);
//        return Response.ok(responseOptionVO);
//	}
//
//
//	/**
//	 * 获取投票选项数据
//	 * @param voteOptionId 投票选项的id
//	 * TODO 用户信息的
//	 */
//	@ApiOperation(value = "获取投票选项数据", notes = "获取投票选项数据", response = VoteOptionVO.class)
//	@GetMapping("/detail")
//	public Response<VoteOptionVO> getVoteOptionDetail(
//			@ApiParam("投票选项id") @RequestParam(name="voteOptionId", required=true) Long voteOptionId ){
//		VoteOptionVO voteOptionVO =  voteOptionClient.getvoteOptionDetail(voteOptionId);
//		return Response.ok(voteOptionVO);
//	}
//
//
//
//
//}
//
