package com.yizhi.application.course.controller;


import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.course.application.feign.LastViewRecordClient;
import com.yizhi.course.application.vo.LastViewRecordVO;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 最后观看记录 前端控制器
 * </p>
 *
 * @author 谢海军123
 * @since 2019-06-18
 */
@Api(tags = "学员端-课程最后观看记录api", description = "根据学员观看的最后时间点，实现续播功能")
@RestController
@RequestMapping("/api/lastViewRecord")
public class LastViewRecordController {

    private Logger LOGGER = LoggerFactory.getLogger(LastViewRecordController.class);

    @Autowired
    LastViewRecordClient lastViewRecordClient;

    @ApiOperation(value = "保存最后的观看记录")
    @GetMapping("/save")
    public Response<Boolean> save(@ApiParam(name = "courseId", value = "查看的课程id")
                                                   @RequestParam(value="courseId") Long courseId,
                                               @ApiParam(name = "chapterId", value = "查看的课程章节id")
                                                    @RequestParam(value="chapterId") Long chapterId,
                                               @ApiParam(name = "viewPonit", value = "观看时间点（数值类型）")
                                                   @RequestParam(value="viewPonit") Long viewPonit){
        RequestContext rt = ContextHolder.get();

        LastViewRecordVO param = new LastViewRecordVO();
        param.setCompanyId(rt.getCompanyId());
        param.setSiteId(rt.getSiteId());
        param.setOrgId(rt.getOrgId());
        param.setAccountId(rt.getAccountId());
        param.setCourseId(courseId);
        param.setChapterId(chapterId);
        param.setViewPonit(viewPonit);
        boolean ret = lastViewRecordClient.save(param);
        if(ret){
            return Response.ok();
        }else{
            return Response.fail("save error");
        }
    }

    @ApiOperation(value = "获取课程或者章节的最后观看记录",response = LastViewRecordVO.class)
    @GetMapping("/get")
    public Response<LastViewRecordVO> get(@ApiParam(name = "courseId", value = "查看的课程id")
                                                @RequestParam(value="courseId") Long courseId,
                                            @ApiParam(name = "chapterId", value = "课程章节，不传就查询课程最后观看章节时间点", required = false)
                                                @RequestParam(value="chapterId",required = false) Long chapterId){
        RequestContext rt = ContextHolder.get();

        LOGGER.info("获取课程或者章节的最后观看记录请求参数：SiteI={},AccountId={},courseId="+courseId+",chapterId="+chapterId,rt.getSiteId(),rt.getAccountId());
        return Response.ok(lastViewRecordClient.get(rt.getSiteId(),rt.getAccountId(),courseId,chapterId));
    }

}

