package com.yizhi.application.pc.vo;


import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 返回体
 *
 * @author lyThinkPad
 */
@Api(
        tags = {"MyRepVO"},
        description = "对象输出类"
)
@Data
public class MyRespVO implements Serializable {

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "名称")
    private String name;
    @ApiModelProperty(value = "开始时间/获取时间;案例的提交时间")
    private Date startTime;
    @ApiModelProperty(value = "截止时间/有效期;案例的提交时间")
    private Date endTime;

    @ApiModelProperty(value = "对应的图片/视频")
    private List<String> images;
    @ApiModelProperty(value = "来源")
    private String source;

    @ApiModelProperty(value = "允许上传次数/允许考试次数")
    private Integer times;

    @ApiModelProperty(value = "合格分数")
    private Integer passScore;

    @ApiModelProperty(value = "作业要求")
    private String detail;

    @ApiModelProperty(value = "课程有效0 失效，1有效")
    private Integer valid;

    @ApiModelProperty(value = "学习百分比")
    private Integer percent;

    @ApiModelProperty("课程评分")
    private Double level;

    @ApiModelProperty("学习时长")
    private Integer duration;

    @ApiModelProperty(value = "作业状态（0,待提交,1,批阅中,2,通过,3,未通过,4,已逾期,5,补交）/考试状态（是否通过：0未通过 1已通过 2阅卷中 3已逾期 4未答卷）")
    private Integer status;

    @ApiModelProperty(value = "考试操作: 0开始考试 1继续考试(无查看记录) 2继续考试(查看记录) 3重新考试(查看记录) 4(只有查看记录)/作业操作 1 详情 2提交作业 3 提交作业&查看详情  4 无操作 5 继续提交&查看详情;" +
            "案例库：是否必须提交0:不必须提交 1:必须提交")
    private Integer handle;

    @ApiModelProperty(value = "考试答案的id")
    private Long answerId;

    @ApiModelProperty(value = "考试：已考次数;案例库：已完成的数量")
    private Integer completionTimes;

    @ApiModelProperty(value = "进行中的数量")
    private Integer processCount;

    @ApiModelProperty(value = "作者")
    private String author;
    
    @ApiModelProperty(value = "完成状态 0已完结 1连载中")
    private Integer overed;
    
    @ApiModelProperty(value = "最新解锁时间")
    private Date unLockTime;
}
