package com.yizhi.application.point.controller;

import java.util.Date;

import com.yizhi.application.point.constant.MQqueuesEnum;
import com.yizhi.application.point.constant.PointEventEnum;
import com.yizhi.point.application.feign.PointRedisFeignClients;
import com.yizhi.point.application.vo.PointParamVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;


@RestController
public class TestController {
	
	private static final Logger LOG = LoggerFactory.getLogger(TestController.class);
	
	@Autowired
	private PointRedisFeignClients pointRedisClient;
	/*@Autowired
	private RabbitTemplate rabbitTemplate;*/
	
	@PostMapping("/test2")
	public void test2(){
		PointParamVO vo = new PointParamVO();
		vo.setEventName(PointEventEnum.POINTEXAM.getKey());
		vo.setActivityType("activityType");
		vo.setActivitySource("activitySource");
		vo.setSourceId(10086L);
		vo.setActivityName("activityName");
		vo.setReleaseCondition("releaseCondition");
		vo.setReleaseCondition("releaseCondition");
		vo.setReleaseRules("releaseRules");
		vo.setOperatingPoint(30);
		vo.setCreatePointTime(new Date());
		vo.setAccountId(10000L);
		vo.setAccountName("bob");
		vo.setOrgId(10000L);
		vo.setSiteId(10000L);
		vo.setCompanyId(10000L);
		String examPointId = pointRedisClient.addPointRedis(vo);
		System.out.println("examPointId=" + examPointId);
		//rabbitTemplate.convertAndSend(MQqueuesEnum.EXAM.getKey(), examPointId);
	}
	
	@PostMapping("/test")
	public void test(){
		LOG.info("开始产生积分");
		PointParamVO vo = new PointParamVO();
		vo.setEventName(PointEventEnum.POINTEXAM.getKey());
		vo.setActivityType("activityType");
		vo.setActivitySource("activitySource");
		vo.setSourceId(10000L);
		vo.setActivityName("activityName");
		vo.setReleaseCondition("releaseCondition");
		vo.setReleaseCondition("releaseCondition");
		vo.setReleaseRules("releaseRules");
		vo.setOperatingPoint(50);
		vo.setCreatePointTime(new Date());
		vo.setAccountId(1314L);
		vo.setAccountName("mcz");
		vo.setOrgId(1314L);
		vo.setSiteId(1314L);
		vo.setCompanyId(1314L);
		String examPointId = pointRedisClient.addPointRedis(vo);
		System.out.println("examPointId=" + examPointId);
		//rabbitTemplate.convertAndSend(MQqueuesEnum.EXAM.getKey(), examPointId);
		LOG.info("开始产生积分-结束");

//		PointParamVO vo = new PointParamVO();
//		vo.setEventName(PointEventEnum.POINTEXAM.getKey());
//		vo.setActivityType("activityType");
//		vo.setActivitySource("activitySource");
//		vo.setSourceId(10086L);
//		vo.setActivityName("activityName");
//		vo.setReleaseCondition("releaseCondition");
//		vo.setReleaseCondition("releaseCondition");
//		vo.setReleaseRules("releaseRules");
//		vo.setOperatingPoint(20);
//		vo.setCreatePointTime(new Date());
//		vo.setAccountId(10000L);
//		vo.setAccountName("bob");
//		vo.setOrgId(10000L);
//		vo.setSiteId(10000L);
//		vo.setCompanyId(10000L);
//		String examPointId = pointRedisClient.addPointRedis(vo);
//		System.out.println("examPointId=" + examPointId);
//		rabbitTemplate.convertAndSend(MQqueuesEnum.EXAM.getKey(), examPointId);
	}
	
	@PostMapping("/test1")
	public void test1(){
		PointParamVO vo = new PointParamVO();
		vo.setEventName(PointEventEnum.POINTVOTE.getKey());
		vo.setActivityType("activityType");
		vo.setActivitySource("activitySource");
		vo.setSourceId(10000L);
		vo.setActivityName("activityName");
		vo.setReleaseCondition("releaseCondition");
		vo.setReleaseCondition("releaseCondition");
		vo.setReleaseRules("releaseRules");
		vo.setOperatingPoint(10);
		vo.setCreatePointTime(new Date());
		vo.setAccountId(10000L);
		vo.setAccountName("bob");
		vo.setOrgId(10000L);
		vo.setSiteId(10000L);
		vo.setCompanyId(10000L);
		String votePointId = pointRedisClient.addPointRedis(vo);
		System.out.println("votePointId=" + votePointId);
		//rabbitTemplate.convertAndSend(MQqueuesEnum.VOTE.getKey(), votePointId);
	}
}
