package com.yizhi.application.assignment.controller;


import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.assignment.application.feign.ManageAssignmentExerciseBookClient;
import com.yizhi.assignment.application.vo.TipoffAssignmentListVO;
import com.yizhi.assignment.application.vo.apivo.ApiAssignmentCommentVO;
import com.yizhi.assignment.application.vo.entity.AssignmentAnswerTipoff;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName AssignmentExpriceBookController
 * @Description TODO
 * @Author shengchenglong
 * @DATE 2019-10-22 11:15
 * @Version 1.0
 */
@Api("作业本--管理端")
@RestController
@RequestMapping("/manage/assignment/exerciseBook")
@Log4j2
public class ManageAssignmentExerciseBookController {

    @Autowired
    private ManageAssignmentExerciseBookClient manageAssignmentExerciseBookClient;


    @GetMapping("/answer/down")
    @ApiOperation(value = "作业上下架", response = Boolean.class)
    public Response<Boolean> answerDown(
            @ApiParam @RequestParam("answerId") Long answerId,
            @ApiParam("是否是下架，0：否，1：是") @RequestParam("isDown") Integer isDown) {
        try {
            return Response.ok(manageAssignmentExerciseBookClient.answerDown(answerId, isDown));
        } catch (Exception e) {
            log.error(e);
            return Response.fail();
        }
    }

    @GetMapping("/answer/delete")
    @ApiOperation(value = "删除作业", response = Boolean.class)
    public Response<Boolean> answerDelete(@ApiParam @RequestParam("answerId") Long answerId) {
        try {
            return Response.ok(manageAssignmentExerciseBookClient.answerDelete(answerId));
        } catch (Exception e) {
            log.error(e);
            return Response.fail();
        }
    }

    @GetMapping("/comment/page")
    @ApiOperation(value = "评论列表", response = ApiAssignmentCommentVO.class)
    public Response<ApiAssignmentCommentVO> commentPage(
            @ApiParam @RequestParam("assignmentAnswerId") Long assignmentAnswerId,
            @ApiParam("要跳转的页数") @RequestParam(name = "pageNo", defaultValue = "1") int pageNo,
            @ApiParam("每页条数，默认：10") @RequestParam(name = "pageSize", defaultValue = "10") int pageSize
    ) {
        try {
            Page<ApiAssignmentCommentVO> page = manageAssignmentExerciseBookClient.commentPage(assignmentAnswerId, pageNo, pageSize);
            Map<String, Integer> pageMap = new HashMap<>();
            pageMap.put("pageNo", pageNo);
            pageMap.put("pageSize", pageSize);
            pageMap.put("pageTotal", page.getTotal());
            return Response.ok(page.getRecords(), pageMap);
        } catch (Exception e) {
            log.error(e);
            return Response.fail();
        }
    }


    @GetMapping("/comment/delete")
    @ApiOperation(value = "评论删除", response = Boolean.class)
    public Response<Boolean> commentDelete(@RequestParam("commentId") Long commentId) {
        try {
            return Response.ok(manageAssignmentExerciseBookClient.commentDelete(commentId));
        } catch (Exception e) {
            log.error(e);
            return Response.fail();
        }
    }

    @GetMapping("/comment/audit")
    @ApiOperation(value = "评论上下架", response = Boolean.class)
    public Response<Boolean> commentAudit(@RequestParam("commentId") Long commentId, @RequestParam("auditStatus") Integer auditStatus) {
        try {
            return Response.ok(manageAssignmentExerciseBookClient.commentAudit(commentId, auditStatus));
        } catch (Exception e) {
            log.error(e);
            return Response.fail();
        }
    }

    @GetMapping("/tipoff/answer/page")
    @ApiOperation(value = "举报-作业列表页", response = TipoffAssignmentListVO.class)
    public Response<TipoffAssignmentListVO> tipoffAnswerPage(
            @ApiParam @RequestParam(name = "assignmentName", required = false) String assignmentName,
            @ApiParam("要跳转的页数") @RequestParam(name = "pageNo", defaultValue = "1") int pageNo,
            @ApiParam("每页条数，默认：10") @RequestParam(name = "pageSize", defaultValue = "10") int pageSize) {
        try {
            Page<TipoffAssignmentListVO> page = manageAssignmentExerciseBookClient.tipoffAnswerPage(assignmentName, pageNo, pageSize);
            Map<String, Integer> pageMap = new HashMap<>();
            pageMap.put("pageNo", pageNo);
            pageMap.put("pageSize", pageSize);
            pageMap.put("pageTotal", page.getTotal());
            return Response.ok(page.getRecords(), pageMap);
        } catch (Exception e) {
            log.error(e);
            return Response.fail();
        }
    }

    @GetMapping("/tipoff/page")
    @ApiOperation(value = "举报-列表页", response = AssignmentAnswerTipoff.class)
    public Response<AssignmentAnswerTipoff> tipoffPage(
            @ApiParam @RequestParam("answerId") Long answerId,
            @ApiParam("要跳转的页数") @RequestParam(name = "pageNo", defaultValue = "1") int pageNo,
            @ApiParam("每页条数，默认：10") @RequestParam(name = "pageSize", defaultValue = "10") int pageSize) {
        try {
            Page<AssignmentAnswerTipoff> page = manageAssignmentExerciseBookClient.tipoffPage(answerId, pageNo, pageSize);
            Map<String, Integer> pageMap = new HashMap<>();
            pageMap.put("pageNo", pageNo);
            pageMap.put("pageSize", pageSize);
            pageMap.put("pageTotal", page.getTotal());
            return Response.ok(page.getRecords(), pageMap);
        } catch (Exception e) {
            log.error(e);
            return Response.fail();
        }
    }

    @GetMapping("/tipoff/remove")
    @ApiOperation(value = "举报-移除", response = Boolean.class)
    public Response<Boolean> tipoffPage(
            @ApiParam @RequestParam("tipoffId") Long tipoffId) {
        try {
            return Response.ok(manageAssignmentExerciseBookClient.tipoffRemove(tipoffId));
        } catch (Exception e) {
            log.error(e);
            return Response.fail();
        }
    }
    
    @GetMapping("/comment/export")
    @ApiOperation(value = "评论导出", response = String.class)
    public Response<String> commentExport(
            @ApiParam("答案id") @RequestParam("answerId") Long answerId
    ) {
        try {
            return Response.ok(manageAssignmentExerciseBookClient.commentExport(answerId));
        } catch (Exception e) {
            log.error(e);
            return Response.fail();
        }
    }

}
