package com.yizhi.application.international.controller;


import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.cache.CacheNamespace;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.task.AbstractTaskHandler;
import com.yizhi.core.application.task.TaskExecutor;
import com.yizhi.site.application.feign.InternationalClient;
import com.yizhi.site.application.vo.site.SiteLanguageVO;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import java.util.List;

/**
 * @author: lly
 * @date: 2020-9-3 17:39:51
 **/
@Log4j2
@Api(tags = "国际化—功能模块-用户选中的语种记录")
@RestController
@RequestMapping("/manage/siteLanguage/record")
public class SiteLanguageRecordController {

    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private InternationalClient internationalClient;

    /**
     * 保存用户选择的语种
     */
    @ApiOperation(value = "保存用户选择的语种")
    @GetMapping(value = "/international/selectLanguage/save")
    public Response selectLanguageSave(@ApiParam(value = "语言code", required = true) @RequestParam(value = "languageCode") String languageCode) {
        setStudentSelectLanguage(ContextHolder.get(), languageCode);
        return Response.ok();
    }

    /**
     * 回显用户选择的语种
     */
    @ApiOperation(value = "回显用户选择的语种")
    @GetMapping(value = "/international/selectLanguage/get")
    public Response getSelectLanguage() {
        return Response.ok(getStudentSelectLanguageRecord(ContextHolder.get()));
    }


    /**
     * 登录成功后设置用户选择的语言
     *
     * @param context
     * @param languageCode
     */
    public void setStudentSelectLanguage(RequestContext context, String languageCode) {
        taskExecutor.asynExecute(new AbstractTaskHandler() {
            @Override
            public void handle() {
                setStudentSelectLanguageRecordCache(context, languageCode);
                setStudentSelectLanguageRecord(context, languageCode);
            }
        });
    }

    /**
     * 设置用户选择的语言缓存
     *
     * @param languageCode
     */
    public void setStudentSelectLanguageRecordCache(RequestContext context, String languageCode) {
        if (languageCode != null) {
            redisCache.hset(CacheNamespace.SITE_LANGUAGE_STUDENT_SELECT, context.getAccountId().toString(), languageCode);
        }
    }

    /**
     * 设置用户选择的语言 入库
     *
     * @param languageCode
     */
    public void setStudentSelectLanguageRecord(RequestContext context, String languageCode) {

        // TODO 后续需要入库

    }

    /**
     * 获取用户选择的语言缓存
     */
    public String getStudentSelectLanguageRecord(RequestContext context) {
        Object languageCodeObject = redisCache.hget(CacheNamespace.SITE_LANGUAGE_STUDENT_SELECT, context.getAccountId().toString());
        String languageCode = null;
        if(languageCodeObject == null){
            //如果缓存没有值，则默认取管理端配置的语种列表第一个
            Page<SiteLanguageVO> page = internationalClient.getList(1, 1, 1);
            List<SiteLanguageVO> records = page.getRecords();
            if (CollectionUtils.isNotEmpty(records)){
                languageCode = records.get(0).getLanguageCode();
                //放置默认语种缓存
                setStudentSelectLanguageRecordCache(context,languageCode);
            }
        }else {
            languageCode = languageCodeObject.toString();
        }
        return languageCode;
    }
}