package com.yizhi.application.portal.controller;

import java.util.ArrayList;
import java.util.List;

import com.yizhi.album.application.feign.AlbumClient;
import com.yizhi.album.application.vo.domain.Album;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.course.application.feign.CourseClient;
import com.yizhi.course.application.feign.MarketingCourseClient;
import com.yizhi.course.application.vo.CourseVo;
import com.yizhi.course.application.vo.domain.CourseEntityVo;
import com.yizhi.exam.application.feign.ExamClient;
import com.yizhi.exam.application.vo.domain.Exam;
import com.yizhi.site.application.feign.BannerManageFeignClients;
import com.yizhi.site.application.feign.InformationManageFeignClients;
import com.yizhi.site.application.vo.domain.InformationVo;
import com.yizhi.site.application.vo.site.*;
import com.yizhi.training.application.feign.TrainingProjectClient;
import com.yizhi.training.application.param.TrainingProjectParam;
import com.yizhi.training.application.vo.domain.TrainingProjectVo;
import com.yizhi.util.application.domain.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.plugins.Page;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * 轮播管理 
 * @author mei 
 * @Date: 2018/3/17 20:30
 */

@Api(tags = "轮播管理")
@RestController
@RequestMapping("/manage/banner")
public class SiteBannerManageController {

	private static final Logger LOGGER = LoggerFactory.getLogger(SiteBannerManageController.class);
	@Autowired
	BannerManageFeignClients bannerManageFeignClients;
	@Autowired
	TrainingProjectClient projectClient;
	@Autowired
	InformationManageFeignClients informationClients;
	@Autowired
	CourseClient courseClient;
	@Autowired
	ExamClient examClient;
	@Autowired
	MarketingCourseClient marketClient;
	@Autowired
	AlbumClient albumClient;
	
	/**
	 */
	@ApiOperation(value = "分页列表", notes = "查询轮播的", response=PortalBannerVo.class)
	@GetMapping("/list")
	public Response<ReturnImageVO> listPage(
			@ApiParam(name = "bannerName", value = "banner名称，营销，首页，培训，课程，新闻资讯，专辑") @RequestParam(name = "bannerName", required = true) String bannerName,
            @ApiParam(name = "terminalName", value = "应用名称，微信，APP，PC", required = true) @RequestParam(name = "terminalName", required = true) String terminalName,
            @ApiParam(name = "imgTitle", value = "图片名称，空查询所有", required = false) @RequestParam(name = "imgTitle", required = false) String imgTitle,
            @ApiParam(name = "state", value = "上架 1，下架 2, 全部 3", required = true) @RequestParam(name = "state", required = true) Integer state,
            @ApiParam(name = "pageNo", value = "跳转页数,默认第一页", required = true) @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
            @ApiParam(name = "pageSize", value = "每页条数,默认20条", required = true) @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize){
		try{
	        
	        SiteComponyIdVO siteComponyIdVO = new SiteComponyIdVO();
	        Long siteId = ContextHolder.get().getSiteId();
	        Long accountId = ContextHolder.get().getAccountId();
	        Long companyId = ContextHolder.get().getCompanyId();
	        String accountName = ContextHolder.get().getAccountName();
	        siteComponyIdVO.setCompanyId(companyId);
	        siteComponyIdVO.setCreateById(accountId);
	        siteComponyIdVO.setCreateByName(accountName);
	        Long orgId = ContextHolder.get().getOrgId();
	        if(orgId==null) {
	        	orgId=0L;
	        }
	        siteComponyIdVO.setState(state);
	        siteComponyIdVO.setOrgId(orgId);
	        siteComponyIdVO.setSiteId(siteId);
	        siteComponyIdVO.setCompanyId(companyId);
        	siteComponyIdVO.setBannerName(bannerName);
        	siteComponyIdVO.setTerminalName(terminalName);
	        siteComponyIdVO.setPageNo(pageNo);
	        siteComponyIdVO.setPageSize(pageSize);
	        siteComponyIdVO.setImgTitle(imgTitle);
	        
			return Response.ok(bannerManageFeignClients.listPage(siteComponyIdVO));
		}catch(Exception e){
			 LOGGER.error("", e);
	         return Response.fail();
		}
	}
	
	/**
	 * 轮播banner预览
	 * @param id
	 * @return
	 */
//	@ApiOperation(value = "轮播banner预览", notes = "轮播banner预览", response=PortalBannerVo.class)
//	@GetMapping("/preview")
//	public Response<List<PortalBannerVo>>  viewMessage(@ApiParam(name = "轮播id", value = "轮播id") @RequestParam("id") Long id){
//		try{
//			return Response.ok(bannerManageFeignClients.viewMessage(id));
//		}catch(Exception e){
//			 LOGGER.error("", e);
//	         return Response.fail();
//		}
//	}
	
	/**
	 * 轮播banner项列表
	 * @return
	 */
//	@ApiOperation(value = "轮播banner项列表", notes = "轮播banner项列表", response=ImageListVO.class)
//	@GetMapping("/item/list")
//	public Response<ImageListVO> selectBanner(
//		@ApiParam(name = "bannerName", value = "banner名称，营销，首页，培训，课程，新闻资讯") @RequestParam(name = "bannerName", required = false) String bannerName,
//        @ApiParam(name = "terminalName", value = "应用名称，全部，移动端，PC", required = true) @RequestParam(name = "terminalName", required = false) String terminalName){
//			
//		ImageListVO imageListVO = new ImageListVO();
//		imageListVO.setBannerName(bannerName);
//		imageListVO.setTerminalName(terminalName);
//		return Response.ok(bannerManageFeignClients.selectBanner(imageListVO));
//	}
	
	/**
	 * 轮播banner图片拖动
	 */
	@ApiOperation(value = "轮播banner图片拖动", notes = "轮播banner图片拖动")
	@PostMapping("/item/drag")
	public Response<Boolean> dragImage(@RequestBody IdTwoVO vo){
		try{
			RequestContext context = ContextHolder.get();
			vo.setAccountId(context.getAccountId());
			vo.setAccountName(context.getAccountName());
			return Response.ok(bannerManageFeignClients.dragImage(vo));
		}catch(Exception e){
			 LOGGER.error("", e);
	         return Response.fail();
		}
	}
	
	
	/**
	 * 轮播banner项新增
	 */
	@ApiOperation(value = "轮播banner项新增", notes = "轮播banner项新增")
	@PostMapping("/item/insert")
	public Response<Long> insertDetail(@RequestBody BannerImageListVO vo){
		try{
			RequestContext context = ContextHolder.get();
			vo.setAccountId(context.getAccountId());
			vo.setAccountName(context.getAccountName());
			return Response.ok(bannerManageFeignClients.insertDetail(vo));
		}catch(Exception e){
			 LOGGER.error("", e);
	         return Response.fail();
		}
	}
	
	/**
	 * 轮播banner图片修改
	 */
	@ApiOperation(value = "轮播banner图片修改", notes = "轮播banner图片修改")
	@PostMapping("/item/update")
	public Response<Long> updateImage(@RequestBody BannerImageListVO vo){
		try{
			RequestContext context = ContextHolder.get();
			vo.setAccountId(context.getAccountId());
			vo.setAccountName(context.getAccountName());
			return Response.ok(bannerManageFeignClients.updateImage(vo));
		}catch(Exception e){
			 LOGGER.error("", e);
	         return Response.fail();
		}
	}
	
	/**
	 * 轮播banner项删除
	 */
	@ApiOperation(value = "轮播banner图片删除", notes = "轮播banner项删除")
	@PostMapping("/item/delete")
	public Response<Boolean> imageDelete(@RequestBody IdOneVO vo){
		try{
			return Response.ok(bannerManageFeignClients.bannerDelete(vo));
		}catch(Exception e){
			 LOGGER.error("", e);
	         return Response.fail();
		}
	}
	
	
	/**
	 * 轮播banner项上架
	 */
	@ApiOperation(value = "轮播banner图片上架", notes = "轮播banner图片上架")
	@PostMapping("/item/up")
	public Response<String> siteUp(@RequestBody IdOneVO vo){
		try{
			return Response.ok(bannerManageFeignClients.bannerUp(vo));
		}catch(Exception e){
			 LOGGER.error("", e);
	         return Response.fail();
		}
	}
	
	/**
	 * 轮播banner项下架
	 */
	@ApiOperation(value = "轮播banner图片下架", notes = "轮播banner图片下架")
	@PostMapping("/item/down")
	public Response<String> siteDown(@RequestBody IdOneVO vo){
		try{
			return Response.ok(bannerManageFeignClients.bannerDown(vo));
		}catch(Exception e){
			 LOGGER.error("", e);
	         return Response.fail();
		}
	}
	
	/**
	 * 轮播banner新增 类型选择
	 */
	@ApiOperation(value = "轮播banner 新增类型选择", notes = "轮播banner 新增类型选择")
	@GetMapping("/type/select")
	public Response<Page<ImageTypeSelectVO>> selectType(
			@ApiParam(name = "type", value = "类型: 课程 1， 考试 2， 培训 3， 新闻资讯 5， 营销 6, 专辑7") @RequestParam(name = "type", required = false) Integer type,
			@ApiParam(name = "name", value = "名称") @RequestParam(name = "name", required = false) String name,
			@ApiParam(name = "pageNo", value = "跳转页数,默认第一页", required = true) @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
            @ApiParam(name = "pageSize", value = "每页条数,默认20条", required = true) @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize
			){
		try{
			List<ImageTypeSelectVO> list = new ArrayList<ImageTypeSelectVO>();
			RequestContext context = ContextHolder.get();
			Long siteId = context.getSiteId();
			Long companyId = context.getCompanyId();
			Long orgId = context.getOrgId();
			if(type == null){
				return Response.fail(InternationalEnums.SITEBANNERMANAGECONTROLLER1.getCode());
			}
			if(name == null){
				name = "";
			}
			
			if(type == 1){  //课程  接口
				List<CourseEntityVo> courseSearchList = courseClient.getCourseSearchList(name, companyId, siteId, 0L);
				LOGGER.info("courseSearchList=" + courseSearchList);
				if(courseSearchList != null && courseSearchList.size() > 0){
					list = formatCourse(courseSearchList);
				}
			}else if(type == 2){  //考试 接口
				List<Exam> selectExamByContext = examClient.selectExamByContext(companyId, orgId, siteId, name);
				LOGGER.info("selectExamByContext=" + selectExamByContext);
				if(selectExamByContext != null && selectExamByContext.size() > 0){
					list = formatExam(selectExamByContext);
				}
			}else if(type == 3){   //培训  接口
				TrainingProjectParam param = new TrainingProjectParam();
				param.setCompanyId(companyId);
				param.setName(name);
//				param.setOrgId(orgId);
				param.setSiteId(siteId);
				param.setStatus(TrainingProjectParam.Status.UP);
				List<TrainingProjectVo> listByParam = projectClient.listByParam(param);
				LOGGER.info("listByParam=" + listByParam);
				if(listByParam != null && listByParam.size() > 0){
					list = fromatProject(listByParam);
				}
			}else if(type == 5){   //新闻  接口
				List<InformationVo> listbyName = informationClients.listbyName(name, siteId);
				LOGGER.info("listbyName=" + listbyName);
				if(listbyName != null && listbyName.size() > 0){
					list = formatNews(listbyName);
				}
			}else if(type == 6){   //营销  接口
				List<CourseVo> courseFindByName = marketClient.courseFindByName(name, companyId, siteId, orgId);
				if(courseFindByName != null && courseFindByName.size() > 0){
					list = formatMarket(courseFindByName);
				}
			}else if (type == 7) {  //专辑 
				List<Album> albumFindByName = albumClient.searchList(name,null, companyId, siteId);
				if(albumFindByName != null && albumFindByName.size() > 0){
					list = fromatAlbum(albumFindByName);
				}
			}
			Page<ImageTypeSelectVO> page = new Page<ImageTypeSelectVO>(pageNo, pageSize);
			Page<ImageTypeSelectVO> setRecords = page.setRecords(list);
			page.setTotal(list.size());
			return Response.ok(setRecords);
		}catch(Exception e){
			 LOGGER.error("", e);
	         return Response.fail();
		}
	}

	private List<ImageTypeSelectVO> formatMarket(List<CourseVo> courseFindByName) {
		List<ImageTypeSelectVO> list = new ArrayList<ImageTypeSelectVO>();
		ImageTypeSelectVO vo = null;
		for(CourseVo c : courseFindByName){
			vo = new ImageTypeSelectVO();
			vo.setId(c.getId());
			vo.setName(c.getName());
//			vo.setCreateTime(c.getCreateTime());
			list.add(vo);
		}
		return list;
	}

	private List<ImageTypeSelectVO> formatExam(List<Exam> selectExamByContext) {
		List<ImageTypeSelectVO> list = new ArrayList<ImageTypeSelectVO>();
		ImageTypeSelectVO vo = null;
		for(Exam c : selectExamByContext){
			vo = new ImageTypeSelectVO();
			vo.setId(c.getId());
			vo.setName(c.getName());
			vo.setCreateTime(c.getCreateTime());
			list.add(vo);
		}
		return list;
	}

	//考试数据格式化
	private List<ImageTypeSelectVO> formatCourse(List<CourseEntityVo> courseSearchList) {
		List<ImageTypeSelectVO> list = new ArrayList<ImageTypeSelectVO>();
		ImageTypeSelectVO vo = null;
		for(CourseEntityVo c : courseSearchList){
			vo = new ImageTypeSelectVO();
			vo.setId(c.getId());
			vo.setName(c.getName());
			vo.setCreateTime(c.getCreateTime());
			list.add(vo);
		}
		return list;
	}

	//新闻数据格式化
	private List<ImageTypeSelectVO> formatNews(List<InformationVo> listbyName) {
		List<ImageTypeSelectVO> list = new ArrayList<ImageTypeSelectVO>();
		ImageTypeSelectVO vo = null;
		for(InformationVo info : listbyName){
			vo = new ImageTypeSelectVO();
			vo.setId(info.getId());
			vo.setName(info.getFileName());
			vo.setCreateTime(info.getCreateTime());
			list.add(vo);
		}
		return list;
	}

	//培训数据格式化
	private List<ImageTypeSelectVO> fromatProject(List<TrainingProjectVo> listByParam) {
		List<ImageTypeSelectVO> list = new ArrayList<ImageTypeSelectVO>();
		ImageTypeSelectVO vo = null;
		for(TrainingProjectVo tp : listByParam){
			vo = new ImageTypeSelectVO(); 
			vo.setId(tp.getId());
			vo.setName(tp.getName());
			vo.setCreateTime(tp.getCreateTime());
			list.add(vo);
		}
		return list;
	}
	
	//专辑数据格式化
	private List<ImageTypeSelectVO> fromatAlbum(List<Album> listByParam) {
		List<ImageTypeSelectVO> list = new ArrayList<ImageTypeSelectVO>();
		ImageTypeSelectVO vo = null;
		for(Album tp : listByParam){
			vo = new ImageTypeSelectVO(); 
			vo.setId(tp.getId());
			vo.setName(tp.getName());
			vo.setCreateTime(tp.getCreateTime());
			list.add(vo);
		}
		return list;
	}
}
