package com.yizhi.application.testInfo.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.tools.PageTools;
import com.yizhi.course.application.feign.TestInfoClient;
import com.yizhi.course.application.vo.TestInfoListReqVO;
import com.yizhi.course.application.vo.TestInfoVO;
import com.yizhi.course.application.vo.TestInfoViewRespVO;
import com.yizhi.course.application.vo.TestSubjectVO;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 17:30 2018/10/15
 * @Modified By
 */
@Api(tags = "管理端-测验接口")
@RestController
@RequestMapping("/manage/testInfo")
public class TestInfoController {

    private static final Logger LOG = LoggerFactory.getLogger(TestInfoController.class);

    @Autowired
    TestInfoClient testInfoClient;

    @ApiOperation(value = "测验信息列表", notes = "组合列表页面参数，查询测验信息列表", response = TestInfoVO.class)
    @PostMapping("/test/list")
    public Response<TestInfoVO> testInfoList(@RequestBody TestInfoListReqVO reqVO){
        LOG.info("测验信息列表处理开始");
        Page<TestInfoVO> data = testInfoClient.testInfoList(reqVO);
        LOG.info("测验信息列表处理的查询列表数据={}", JSON.toJSONString(data));
        return Response.ok(PageTools.split(data));
    }

    @ApiOperation(value = "测验信息试题列表", notes = "组合列表页面参数，查询测验信息试题列表", response = TestSubjectVO.class)
    @GetMapping("/test/subject/list")
    public Response<TestSubjectVO> testSubInfoList(@RequestParam("id") Long id){
        List<TestSubjectVO> data = testInfoClient.listSubject(id);
        return Response.ok(data);
    }

    @ApiOperation(value = "根据id列表删除测验信息", notes = "根据id列表删除测验信息")
    @PostMapping("/test/ids/delete")
    public Response<Boolean> testInfoDelete(@ApiParam(name = "deleteTestIds", value = "删除的测验id列表", required = true)
                                                @RequestBody List<Long> deleteTestIds){
        return Response.ok(testInfoClient.testInfoDelete(deleteTestIds));
    }

    @ApiOperation(value = "新增或修改测验信息", notes = "存在测验id表示更新，不存在新增",response = TestInfoVO.class)
    @PostMapping("/test/save")
    public Response<TestInfoVO> testInfoSave(@RequestBody TestInfoVO vo){
        LOG.info("新增或修改测验信息 的请求参数={}",JSON.toJSONString(vo));
        TestInfoVO ret = testInfoClient.testInfoSave(vo);
        if(StringUtils.isNotBlank(ret.getMsgCode())){
            return Response.fail(ret.getMsgCode(),ret.getMsgContext());
        }
        return Response.ok(ret);
    }

    @ApiOperation(value = "查看测验详细信息", notes = "根据测验id查询")
    @GetMapping("/test/view")
    public Response<TestInfoViewRespVO> testInfoView(@ApiParam(name = "id", value = "测验id", required = true)
                                                         @RequestParam(value = "id") Long id ){
        return Response.ok(testInfoClient.testInfoView(id));
    }

    @ApiOperation(value = "新增测验试题", notes = "如果测验不存在，会新增对象返回，包含生成测验id",response = TestSubjectVO.class)
    @PostMapping("/testSubject/save")
    public Response<TestSubjectVO> testSubjectSave(@RequestBody TestSubjectVO vo){
        return Response.ok(testInfoClient.testSubjectSave(vo));
    }

    @ApiOperation(value = "删除测验试题", notes = "根据测验试题id")
    @GetMapping("/testSubject/delete")
    public Response<Boolean> testSubjectDelete(@ApiParam(name = "id", value = "测验试题id", required = true)
                                                   @RequestParam("id") Long id){
        return Response.ok(testInfoClient.testSubjectDelete(id));
    }

    @ApiOperation(value = "查看试题详细信息", notes = "根据测验试题id", response = TestSubjectVO.class)
    @GetMapping("/testSubject/view")
    public Response<TestSubjectVO> testSubjectView(@ApiParam(name = "id", value = "测验试题id", required = true)
                                                       @RequestParam("id") Long id){
        return Response.ok(testInfoClient.testSubjectView(id));

    }

    @ApiOperation(value = "试题移动", notes = "根据测验试题id做试题移动",response = TestSubjectVO.class)
    @GetMapping("/testSubject/move")
    public Response<TestSubjectVO> testSubjectMove(@ApiParam(name = "id", value = "测验试题id", required = true)
                                                 @RequestParam("id") Long id,
                                             @ApiParam(name = "moveType", value = "移动类型 up表示上移，down表示下移", required = true)
                                                 @RequestParam("moveType") String moveType){
        return Response.ok(testInfoClient.sort(id,moveType));
    }

    @ApiOperation(value = "修改试题分数", notes = "修改试题分数")
    @GetMapping("/testSubject/score/update")
    public Response<Boolean> updateScore(@ApiParam(name = "id", value = "测验试题id", required = true)
                               @RequestParam("id") Long id,
                               @ApiParam(name = "score", value = "测验试题分数", required = true)
                               @RequestParam("score") Integer score){
        return Response.ok(testInfoClient.updateScore(id,score));
    }
}
