package com.yizhi.application.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class CalendarTask {

    @ApiModelProperty("业务id")
    public Long taskId;

    @ApiModelProperty("业务类型")
    public Integer taskType;

    @ApiModelProperty("业务类型")
    public String taskTypeString;

    @ApiModelProperty("业务名称")
    public String taskName;

    @ApiModelProperty("业务logo")
    public String taskLogo;

    @ApiModelProperty("业务状态标签")
    public String taskTag;

    @ApiModelProperty("业务允许的次数")
    public Integer taskCanNum;

    @ApiModelProperty("业务已使用的次数")
    public Integer taskUseNum;

    @ApiModelProperty("业务按钮状态")
    public List<String> taskButtonStatus;

    @ApiModelProperty("业务开始时间")
    public Date taskStartDate;

    @ApiModelProperty("业务结束时间")
    public Date taskEndDate;

    @ApiModelProperty("业务截止时间")
    public Date finishDate;

    @ApiModelProperty("直播频道号")
    public String channel;

    @ApiModelProperty("观看类型：0: 公开播放 ; 1: 站内授权播放; ")
    private Integer viewType;

    @ApiModelProperty("自定义排序字段")
    private int sort;

    @ApiModelProperty("任务关联人名称")
    public String relationUserName;
}

