package com.yizhi.application.accountUtil;


import com.yizhi.system.application.system.remote.AccountClient;
import com.yizhi.system.application.system.remote.OrganizationClient;
import com.yizhi.system.application.vo.AccountVO;
import com.yizhi.system.application.vo.OrgVO;
import com.yizhi.system.application.vo.UserInfoVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class AuthorizeQueryAccount {
    @Autowired
    private AccountClient accountClient;
    @Autowired
    private OrganizationClient organizationClient;


    /**
     * 返回《accountId,account》的map
     *
     * @param accountIds
     * @return
     */
    public Map<Long, AccountVO> queryAccountByIds(List<Long> accountIds) {
        if (!CollectionUtils.isEmpty(accountIds)) {
            Map<Long, AccountVO> map = new HashMap<>(accountIds.size());
            List<AccountVO> accountVOS = accountClient.findByIds(accountIds);
            //组装map 以免双重循环
            if (!CollectionUtils.isEmpty(accountVOS)) {
                accountVOS.forEach(a -> {
                    if (!map.containsKey(a.getId())) {
                        map.put(a.getId(), a);
                    }
                });
            }
            return map;
        }

        return null;
    }


    public Map<Long, OrgVO> queryOrgByIds(List<Long> orgIds) {
        if (!CollectionUtils.isEmpty(orgIds)) {
            Map<Long, OrgVO> map = new HashMap<>(orgIds.size());
            List<OrgVO> orgVOS = null;
            try {
                orgVOS = organizationClient.listByOrgIds(orgIds);
            } catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            //组装map 以免双重循环
            if (!CollectionUtils.isEmpty(orgVOS)) {
                orgVOS.forEach(a -> {
                    if (!map.containsKey(a.getId())) {
                        map.put(a.getId(), a);
                    }
                });
            }
            return map;
        }
        return null;
    }

    /**
     * 根据用户名，姓名，或部门名称查询账号列表
     *
     * @param userInfoVO
     * @return
     */
    public Map<Long, UserInfoVO> selectUserInfo(@RequestBody UserInfoVO userInfoVO) {
        return accountClient.selectUserInfo(userInfoVO);
    }


}
