package com.yizhi.application.assignment.vo.manage;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 保存resrarch vo
 *
 * @Author: shengchenglong
 * @Date: 2018/3/13 11:06
 */
@Data
@Api(tags = "ResearchVo", description = "后台保存调研vo")
public class ResearchVo {

    @ApiModelProperty("调研编码，系统将自动生成调研编码；编码规则，按创建顺序累加，例如DY000001，DY000002")
    private String researchNo;

    @ApiModelProperty("积分，每次投票能获取到的积分，默认0")
    private Integer point;

    @ApiModelProperty("提醒设置，0否 1是，默认0")
    private Integer remind;

    @ApiModelProperty("调研名称")
    private String name;

    @ApiModelProperty("开始时间")
    private Date startTime;

    @ApiModelProperty("结束时间")
    private Date endTime;

    @ApiModelProperty("可见范围，1平台用户可见（企业下所有人员） 2指定学员可见")
    private Integer visibleRange;

    @ApiModelProperty("调研说明")
    private String content;

    @ApiModelProperty("状态，0删除 1上架 2下架")
    private Integer state;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("创建人ID")
    private String createById;

    @ApiModelProperty("创建人姓名")
    private String createByName;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("修改人ID")
    private String updateById;

    @ApiModelProperty("修改人姓名")
    private String updateByName;

    @ApiModelProperty("发布时间")
    private Date releaseTime;

    @ApiModelProperty("发布人ID")
    private Long releaseById;

    @ApiModelProperty("发布人姓名")
    private String releaseByName;

    @ApiModelProperty("在培训项目中发起投票，保存对应关系")
    private Long trainingProjectId;

    @ApiModelProperty("企业_ID")
    private Long companyId;

    @ApiModelProperty("部门_ID")
    private Long orgId;

    @ApiModelProperty("站点_ID")
    private Long siteId;

}
