package com.yizhi.application.calendar;

import com.yizhi.calendar.application.feign.CalendarClient;
import com.yizhi.calendar.application.vo.CalendarParam;
import com.yizhi.calendar.application.vo.CalendarVO;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@Api(tags = "管理端-签到打卡接口")
@RestController
@RequestMapping("/manage/calendar")
public class ManageCalendarController {

    private static final Logger LOG = LoggerFactory.getLogger(ManageCalendarController.class);
    
    @Autowired
    private CalendarClient calendarClient;
    
    @ApiOperation(value = "签到打卡规则回显接口",response = CalendarVO.class)
    @GetMapping(value = "/get")
    public Response<CalendarVO> get(){
		try {
			CalendarVO vo = calendarClient.getCalendar();
			return Response.ok(vo);
		} catch (Exception e) {
			LOG.error("签到打卡规则查询失败！！！"+e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
          }
    }
    
    @PostMapping(value = "/save")
    public Response<Boolean> insert(@RequestBody CalendarParam calendarParam){
    	try {
			Boolean b = calendarClient.insertCalendarPointSet(calendarParam);
			if (b) {
                return Response.ok(ReturnCode.SUCCESS);
			}else {
                return  Response.fail(ReturnCode.SAVE_FAIL.getCode(),ReturnCode.SAVE_FAIL.getMsg());
			}
		} catch (Exception e) {
			LOG.error("签到打卡入库失败！！！"+e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
		}
    }
}
