package com.yizhi.application.international.controller;


import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.international.service.InternationalExportService;
import com.yizhi.application.tools.PageTools;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.feign.InternationalClient;
import com.yizhi.site.application.vo.site.InternationalFileUpVO;
import com.yizhi.site.application.vo.site.InternationalVO;
import com.yizhi.util.application.date.DateUtil;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @description: 国际化
 * @author: lly
 * @date: 2020-9-3 17:39:51
 **/
@Log4j2
@Api(tags = "国际化——one")
@RestController
@RequestMapping("/manage/international")
public class InternationalController {

    @Autowired
    private InternationalExportService internationalExportService;
    @Autowired
    private InternationalClient internationalClient;

    @GetMapping("/exportInternational")
    public Response<String> exportLecturer(@RequestParam(name = "keywords", required = false) String keywords,
                                           @RequestParam(name = "type", required = false) Integer type,
                                           @RequestParam(name = "languageId", required = false) Long languageId,
                                           @RequestParam(name = "state", required = false) Integer state
    ) {
        RequestContext context = ContextHolder.get();
        List<InternationalVO> internationalVOS = internationalClient.findInternationalList(type, languageId, keywords, state);

        Map<String, Object> map = new HashMap<String, Object>();
        map.put("list", internationalVOS);
        map.put("siteId", context.getSiteId());
        map.put("companyId", context.getCompanyId());
        map.put("accountId", context.getAccountId());
        map.put("languageId", languageId);
        map.put("type", type);
        String taskLogSerialNo = "INTERNATIONAL-" + DateUtil.getYMDHMSS();

//        0管理端 1 移动端 2 PC端
        String terminalName = "";

        map.put("terminalName", terminalName);
        log.info("map参数：" + map);
        internationalExportService.execute(map, Boolean.TRUE);

        return Response.ok("导出成功，任务编号：" + taskLogSerialNo + ",请在任务管理中下载查看完成情况!");
    }


    /**
     * 查询国际化的管理管的列表
     *
     * @param type
     * @param languageId
     * @param keywords
     * @param state
     * @return
     */
    @GetMapping("/page")
    public Response<InternationalVO> findInternationalList(
            @RequestParam(name = "type", required = false) Integer type,
            @RequestParam(name = "languageId", required = false) Long languageId,
            @RequestParam(name = "keywords", required = false) String keywords,
            @RequestParam(name = "state", required = false) Integer state,
            @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
            @RequestParam(name = "pageSize", required = false, defaultValue = "20") Integer pageSize
    ) {
        Page<InternationalVO> internationalPage = null;
        try {
            internationalPage = internationalClient.findInternationalPage(type, languageId, keywords, state, pageNo, pageSize);
        } catch (Exception e) {
            log.info("返回的接口：{}", e.getMessage());
        }
        return Response.ok(PageTools.versaPage(internationalPage));
    }

    /**
     * 修改国际化实体
     *
     * @param internationalVO
     * @return
     */
    @PostMapping("/update")
    public Response<InternationalVO> updateInternational(
            @RequestBody InternationalVO internationalVO) {
        try {
            internationalVO = internationalClient.updateInternational(internationalVO);
        } catch (Exception e) {
            e.printStackTrace();
            log.info("当前修改的结果：{}", e.getMessage());
        }
        return Response.ok(internationalVO);
    }

    /**
     * 国际化导入
     *
     * @param model
     * @return
     */
    @ApiOperation(value = "国际化导入", notes = "国家化导入")
    @PostMapping(value = "/import")
    public Response<String> importCourse(@RequestBody InternationalFileUpVO model) {
        try {
            String taskLogSerialNo = internationalClient.importInternational(model);
            return Response.ok(taskLogSerialNo);
        } catch (Exception e) {
            return Response.fail(Constants.LECTURER_MSG_BIZ_ERROR);
        }
    }

    /**
     * 初始化语言json redis
     */
    @GetMapping(value = "/international/language/init")
    public Response initLanguage() {
        internationalClient.initLanguage();
        return Response.ok();
    }

    /**
     * 获取语言json
     *
     * @param type
     * @param languageCode
     * @return
     */
    @GetMapping("/public/language/get")
    public Response<String> getLanguage(@RequestParam(name = "type", required = true) Integer type,
                              @RequestParam(name = "languageCode", required = true) String languageCode) {
        HashMap<String, String> language = internationalClient.getLanguage(type, languageCode);

        return Response.ok(JSON.toJSON(language));
    }
}