package com.yizhi.application.lecturer.Controller;


import com.yizhi.lecturer.application.feign.LecturerClient;
import com.yizhi.lecturer.application.vo.LecturerInfoVO;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.log4j.Log4j2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @description: 讲师库字典
 * @author: lly
 * @date: 2019-04-18 11:50
 **/
@Log4j2
@Api(tags = "讲师基本信息")
@RestController
@RequestMapping("/manage/lecturer/info")
public class LecturerInfoController {

    private static final Logger LOG = LoggerFactory.getLogger(LecturerInfoController.class);

    @Autowired
    private LecturerClient lecturerClient;

    @ApiOperation(value = "基本信息新增", notes = "基本信息新增", response = LecturerInfoVO.class)
    @PostMapping(value = "/add")
    public Response<LecturerInfoVO> add(@RequestBody LecturerInfoVO lecturerInfoVO) {
        try {
            LecturerInfoVO resultVO
                    = lecturerClient.add(lecturerInfoVO);
            return Response.ok(resultVO);
        } catch (Exception e) {
            return Response.fail(Constants.LECTURER_MSG_BIZ_ERROR);
        }
    }

    /**
     * 修改讲师基本信息
     *
     * @param lecturerInfoVO
     * @return
     */
    @ApiOperation(value = "基本信息修改", notes = "基本信息修改", response = LecturerInfoVO.class)
    @PostMapping(value = "/update")
    public Response<LecturerInfoVO> update(@RequestBody LecturerInfoVO lecturerInfoVO) {
        try {
            LecturerInfoVO resultVO
                    = lecturerClient.update(lecturerInfoVO);
            return Response.ok(resultVO);
        } catch (Exception e) {
            return Response.fail(Constants.LECTURER_MSG_BIZ_ERROR);
        }
    }

    /**
     * 获取基本信息
     *
     * @return
     */
    @ApiOperation(value = "获取基本信息", notes = "获取基本信息", response = LecturerInfoVO.class)
    @GetMapping(value = "/get")
    public Response<String> get() {
        return Response.ok(lecturerClient.get());
    }


}