package com.yizhi.application.portal.controller;


import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.site.application.feign.MyItemConfigManageClients;
import com.yizhi.site.application.vo.domain.MyItemConfigVo;
import com.yizhi.site.application.vo.site.MyItemConfigVO;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Iterator;
import java.util.List;

/**
 * <p>
 * 我的配置
 * </p>
 *
 * @author hutao123
 * @since 2019-02-21
 */
@Api(tags = "管理端-我的配置", description = "我的配置")
@RestController
@RequestMapping("/manage/myItemConfig")
public class MyItemConfigManageComtroller {
    public static final String OPERATION_FAIL = "操作失败！";
    public static final String OPERATION_SUCCESS = "操作成功！";
    public static final String ID_NOT_EXSIT = "主键不能为空！";
    @Autowired
    MyItemConfigManageClients myItemConfigManageClients;
    @Autowired
    private RedisCache redisCache;


    @PostMapping("/add")
    @ApiOperation(value = "添加配置", response = String.class)
    public Response add(@ApiParam(value = "myItemConfig") @RequestBody MyItemConfigVo myItemConfig) {
        Integer i = myItemConfigManageClients.add(myItemConfig);
        if (i == 1) {
            return Response.ok(OPERATION_SUCCESS);
        } else if (i == 0) {
            return Response.fail(ID_NOT_EXSIT);

        }
        return Response.fail(OPERATION_FAIL);

    }

    /**
     * @param itemId
     * @return
     */
    @GetMapping("/delete")
    @ApiOperation(value = "删除配置", response = String.class)
    public Response delete(@ApiParam(value = "itemId") @RequestParam(value = "itemId") Long itemId) {
        System.out.println("itemId:" + itemId);
        Integer i = myItemConfigManageClients.delete(itemId);
        if (i == 1) {
            return Response.ok(OPERATION_SUCCESS);
        } else if (i == 0) {
            return Response.fail(ID_NOT_EXSIT);
        }
        return Response.fail(OPERATION_FAIL);


    }

    /**
     * @param itemId
     * @param showable 是否显示:0不显示,1显示（默认为0）
     * @return
     */
    @GetMapping("/showable")
    @ApiOperation(value = "配置是否显示", response = String.class)
    public Response showable(@ApiParam(value = "itemId") @RequestParam(value = "itemId") Long itemId,
                             @ApiParam(value = "showable") @RequestParam(value = "showable") Integer showable) {
        Integer i = myItemConfigManageClients.showable(itemId, showable);
        if (i == 1) {
            return Response.ok(OPERATION_SUCCESS);
        } else if (i == 0) {
            return Response.fail(ID_NOT_EXSIT);

        }
        return Response.fail(OPERATION_FAIL);

    }


    @PostMapping("/update")
    @ApiOperation(value = "更新配置", response = String.class)
    public Response update(@ApiParam(value = "myItemConfig") @RequestBody MyItemConfigVo myItemConfig) {
        Integer i = myItemConfigManageClients.update(myItemConfig);
        if (i == 1) {
            String key = "site_my_item:app";
            String[] items = {ContextHolder.get().getSiteId().toString()};
            redisCache.hdel(key, items);
            return Response.ok(OPERATION_SUCCESS);
        } else if (i == 0) {
            return Response.fail(ID_NOT_EXSIT);

        }
        return Response.fail(OPERATION_FAIL);

    }

    @GetMapping("/queryById")
    @ApiOperation(value = "根据ID查询", response = MyItemConfigVO.class)
    public Response<MyItemConfigVO> queryById(@ApiParam(value = "id") @RequestParam(value = "itemId") Long itemId) {
        MyItemConfigVO vo = myItemConfigManageClients.queryById(itemId);
        return Response.ok(vo);

    }

    /**
     * 根据条件，查询相应的list
     *
     * @param name         项目名称
     * @param showable     是否显示:0不显示,1显示（默认为0）
     * @param terminalType 终端类型：1-PC端、2-移动端 3-PC端&移动端
     * @return
     */
    @GetMapping("/queryMyitemConfigByCondition")
    @ApiOperation(value = "根据条件，查询相应的list", response = MyItemConfigVO.class)
    public Response<List<MyItemConfigVO>> queryMyitemConfigByCondition(@ApiParam(value = "name") @RequestParam(value = "name", required = false) String name,
                                                                       @ApiParam(value = "showable") @RequestParam(value = "showable", required = false) Integer showable,
                                                                       @ApiParam(value = "terminalType") @RequestParam(value = "terminalType", required = false) Integer terminalType) {
        List<MyItemConfigVO> myItemConfigVOS = myItemConfigManageClients.queryMyitemConfigByCondition(name, showable, terminalType);
        if(!myItemConfigVOS.isEmpty()){
            Iterator<MyItemConfigVO> it=myItemConfigVOS.iterator();
            while (it.hasNext()){
                MyItemConfigVO myItemConfigVO=it.next();
                if (myItemConfigVO.getItemType()==6||myItemConfigVO.getItemType()==14){
                    it.remove();
                }
            }
        }
        return Response.ok(myItemConfigVOS);
    }

    /**
     * @param id   栏目id
     * @param type 1-代表上移  2-代表下移
     * @return
     */
    @ApiOperation(value = "排序接口", response = Integer.class)
    @GetMapping("/move")
    public Response<Integer> move(@ApiParam(value = "id") @RequestParam(value = "id") Long id,
                                  @ApiParam(value = "type：1-上移 2-下移") @RequestParam(value = "type") Integer type) {
        Integer i = myItemConfigManageClients.move(type, id);
        if (i == -1) {
            return Response.fail(InternationalEnums.DOCUMENTCLASSIFYCOMTROLLER2.getCode());
        } else if (i == -2) {
            return Response.fail(InternationalEnums.MYITEMCONFIGMANAGECOMTROLLER1.getCode());
        }else if(i == -3){
            return Response.fail(InternationalEnums.MYITEMCONFIGMANAGECOMTROLLER2.getCode());
        }else if (i== -4){
            return Response.fail(InternationalEnums.MYITEMCONFIGMANAGECOMTROLLER3.getCode());
        }
        String key = "site_my_item:app";
        String[] items = {ContextHolder.get().getSiteId().toString()};
        redisCache.hdel(key, items);
        return Response.ok(i);
    }


}