package com.yizhi.application.portal.controller;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.feign.PageFooterClient;
import com.yizhi.site.application.vo.domain.PageFooterItemVo;
import com.yizhi.site.application.vo.domain.PageFooterVo;
import com.yizhi.site.application.vo.site.PageFooterItemConfigVo;
import com.yizhi.site.application.vo.site.PageFooterItemSortUpdateVo;
import com.yizhi.site.application.vo.site.PageFooterVO;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Api(tags = "管理端_底页编辑", description = "底页编辑")
@RestController
@RequestMapping("/manage/page")
public class PageFooterController {

    private Logger logger = LoggerFactory.getLogger(PageFooterController.class);

    @Autowired
    private PageFooterClient pageFooterClient;


    @PostMapping("/pageFooter/save")
    @ApiOperation(value = "新增页底信息", notes = "新增")
    public Response<PageFooterVo> pageFooterSave(@ApiParam(name = "PageFooter", value = "") @RequestBody PageFooterVo pageFooter){
        try {
            PageFooterVo footer = pageFooterClient.pageFooterSave(pageFooter);
            return Response.ok(footer);
        }catch (Exception e){
            logger.error("新增页底信息失败");
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }

    }

//    @PostMapping("/pageFooterItem/save")
//    @ApiOperation(value = "新文案", notes = "新增")
//    public Response<PageFooterItem> pageFooterItemSave(@ApiParam(name = "PageFooterItem", value = "") @RequestBody PageFooterItem pageFooterItem){
//        try {
//            PageFooterItem footerItem = pageFooterClient.pageFooterItemSave(pageFooterItem);
//            return Response.ok(footerItem);
//        }catch (Exception e){
//            logger.error("新增文案失败");
//            return Response.fail(Constants.MSG_BIZ_FAIL);
//        }
//
//    }

    @PostMapping("/pageFooterItemConfig/save")
    @ApiOperation(value = "新增链接", notes = "新增")
    public Response<PageFooterItemConfigVo> spageFooterItemConfigSave(@ApiParam(name = "pageFooterItemConfigVo", value = "") @RequestBody PageFooterItemConfigVo pageFooterItemConfigVo){
        try {
            PageFooterItemConfigVo footerItemConfig = pageFooterClient.spageFooterItemConfigSave(pageFooterItemConfigVo);
            return Response.ok(footerItemConfig);
        }catch (Exception e){
            logger.error("新增链接失败");
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }

    }

    @GetMapping("/pageFooterItem/delete")
    @ApiOperation(value = "删除页底信息", notes = "删除")
    public Response<String> delete(@ApiParam(name = "PageFooterItem" ,value = "传入pageFooterItemId")@RequestParam Long id){

        try{
            Boolean result = pageFooterClient.delete(id);
            if (result){
                return Response.ok(result);
            }else {
                return Response.fail(Constants.MSG_BIZ_FAIL);
            }
        }catch (Exception e){
            logger.error("删除失败",e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }

    }

    @GetMapping("/pageFooterItem/getList")
    @ApiOperation(value = "新增回显查询列表", response = PageFooterVO.class)
    public Response <PageFooterVO> selectPageList(@ApiParam(name = "TerminalType", value = "传入的类型(1 PC, 2 App, 3 微信)") @RequestParam(name = "TerminalType") Integer TerminalType

    ){
        PageFooterVO vos = pageFooterClient.getList(TerminalType);
        return Response.ok(vos);

    }

    @GetMapping("/pageFooterItem/get")
    @ApiOperation(value = "查询页底信息", response = PageFooterVO.class)
    public Response <PageFooterVO> selectPage(@ApiParam(name = "TerminalType", value = "传入的类型(1 PC, 2 App, 3 微信)") @RequestParam(name = "TerminalType") Integer TerminalType

    ){
        PageFooterVO vos = pageFooterClient.selectPage(TerminalType);
        return Response.ok(vos);

    }


    @PostMapping("/pageFooterItem/sort")
    @ApiOperation(value = "排序(文案、链接)", notes = "排序")
    public Response<Integer> pageFooterItemSort(@RequestBody List<PageFooterItemSortUpdateVo> list){

        try{
            if (CollectionUtils.isEmpty(list)){
                logger.error("参数不可为空");
                return Response.fail(Constants.MSG_BIZ_FAIL);
            }

            RequestContext context = ContextHolder.get();
            Date date = new Date();

            List<PageFooterItemVo> pageFooterItems = new ArrayList<>(list.size());
            PageFooterItemVo item = null;
            for (PageFooterItemSortUpdateVo vo : list) {
                item = new PageFooterItemVo();
                item.setId(vo.getId());
                item.setSort(vo.getSort());
                item.setUpdateByName(context.getAccountName());
                item.setUpdateById(context.getAccountId());
                item.setUpdateTime(date);
                pageFooterItems.add(item);
            }

            return Response.ok(pageFooterClient.pageFooterItemSort(pageFooterItems));
        }catch (Exception e){
            logger.error("排序失败", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

}
