package com.yizhi.application.project.controller;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.accountUtil.AuthorizeQueryAccount;
import com.yizhi.application.util.TaskSendMessage;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.core.application.exception.BizException;
import com.yizhi.sign.application.feign.SignManageClient;
import com.yizhi.sign.application.feign.SignRecordApiClient;
import com.yizhi.site.application.feign.PortalManagePCFeignClients;
import com.yizhi.site.application.vo.domain.ProtalPlateVo;
import com.yizhi.system.application.vo.AccountVO;
import com.yizhi.system.application.vo.OrgVO;
import com.yizhi.training.application.constant.ProjectConstant;
import com.yizhi.training.application.feign.TpPlanClient;
import com.yizhi.training.application.feign.TpProjectClient;
import com.yizhi.training.application.feign.TrainingProjectClient;
import com.yizhi.training.application.model.BaseModel;
import com.yizhi.training.application.vo.domain.TpAuthorizationRangeVo;
import com.yizhi.training.application.vo.domain.TrainingProjectSaveVo;
import com.yizhi.training.application.vo.domain.TrainingProjectVo;
import com.yizhi.training.application.vo.manage.SearchProjectVo;
import com.yizhi.training.application.vo.manage.TrainingProjectStepThreeVo;
import com.yizhi.training.application.vo.manage.VisibleRangeVo;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.BizResponse;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import javax.naming.Name;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 培训项目主体表（报名、签到 是在报名签到表中记录项目id，论坛是单独的关系表） 前端控制器
 * </p>
 *
 * @author shengchenglong
 * @since 2018/3/27 14:05
 */

@Api(tags = "培训项目接口")
@RestController
@RequestMapping("/manage/trainingProject")
public class TrainingProjectController {

    private static final Logger LOGGER = LoggerFactory.getLogger(TrainingProjectController.class);
    @Autowired
    TpProjectClient tpProjectClient;
    @Autowired
    private TrainingProjectClient trainingProjectClient;
//    @Autowired
//    private SystemMessageClient systemMessageClient;

    @Autowired
    private SignManageClient signManageClient;

    @Autowired
    private TpPlanClient tpPlanClient;

    @Autowired
    private SignRecordApiClient signRecordApiClient;

    @Autowired
    private AuthorizeQueryAccount queryAccount;

    @Autowired
    private TaskSendMessage taskSendMessage;

    @Autowired
    private PortalManagePCFeignClients portalManagePCFeignClient;

    @Value("${pc.host.url}")
    String pcHostUrl;


    @GetMapping(value = "/list")
    @ApiOperation(value = "培训项目分页列表", notes = "返回带分页的项目列表", response = TrainingProjectVo.class)
    public BizResponse<Page<TrainingProjectVo>> list(
            @ApiParam(name = "name", value = "名称或者关键字", required = false) @RequestParam(name = "name", required = false) String name,
            @ApiParam(name = "tpClassificationId", value = "分类id，未分类传0", required = false) @RequestParam(name = "tpClassificationId", required = false) Long tpClassificationId,
            @ApiParam(name = "status", value = "0 未上架 1 已上架 2 草稿", required = false) @RequestParam(name = "status", required = false) Integer status,
            @ApiParam(name = "pageNo", value = "跳转页数,默认第一页", required = true) @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
            @ApiParam(name = "pageSize", value = "每页条数,默认20条", required = true) @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize,
            @ApiParam(name = "enrollStatus", value = "10:无需报名；20:免费报名；30:收费报名；默认空") @RequestParam(name = "enrollStatus",required = false) Integer enrollStatus
    ) {
        SearchProjectVo searchProjectVo = new SearchProjectVo();
        searchProjectVo.setName(name);
        searchProjectVo.setTpClassificationId(tpClassificationId);
        searchProjectVo.setStatus(status);
        searchProjectVo.setPageNo(pageNo);
        searchProjectVo.setPageSize(pageSize);
        searchProjectVo.setEnrollStatus(enrollStatus);
        RequestContext requestContext = ContextHolder.get();
        if (requestContext.isAdmin()) {
            searchProjectVo.setCompanyId(requestContext.getCompanyId());
            searchProjectVo.setSiteId(requestContext.getSiteId());
        } else {
            searchProjectVo.setCompanyId(requestContext.getCompanyId());
            searchProjectVo.setOrgId(requestContext.getOrgIds());
            searchProjectVo.setSiteId(requestContext.getSiteId());
        }
        Page<TrainingProjectVo> page = tpProjectClient.listV2(searchProjectVo);
        return BizResponse.ok(page);
    }

    @GetMapping(value = "/list/v2")
    @ApiOperation(value = "培训项目分页列表版本2", notes = "返回带分页的项目列表", response = TrainingProjectVo.class)
    public BizResponse<Page<TrainingProjectVo>> listV2(
            @ApiParam(name = "name", value = "名称或者关键字", required = false) @RequestParam(name = "name", required = false) String name,
            @ApiParam(name = "tpClassificationId", value = "分类id，未分类传0", required = false) @RequestParam(name = "tpClassificationId", required = false) Long tpClassificationId,
            @ApiParam(name = "status", value = "0 未上架 1 已上架 2 草稿", required = false) @RequestParam(name = "status", required = false) Integer status,
            @ApiParam(name = "pageNo", value = "跳转页数,默认第一页", required = true) @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
            @ApiParam(name = "pageSize", value = "每页条数,默认20条", required = true) @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize,
            @ApiParam(name = "enrollStatus", value = "10:无需报名；20:免费报名；30:收费报名；默认空") @RequestParam(name = "enrollStatus",required = false) Integer enrollStatus
    ) {
        SearchProjectVo searchProjectVo = new SearchProjectVo();
        searchProjectVo.setName(name);
        searchProjectVo.setTpClassificationId(tpClassificationId);
        searchProjectVo.setStatus(status);
        searchProjectVo.setPageNo(pageNo);
        searchProjectVo.setPageSize(pageSize);
        searchProjectVo.setEnrollStatus(enrollStatus);
        RequestContext requestContext = ContextHolder.get();
        if (requestContext.isAdmin()) {
            searchProjectVo.setCompanyId(requestContext.getCompanyId());
            searchProjectVo.setSiteId(requestContext.getSiteId());
        } else {
            searchProjectVo.setCompanyId(requestContext.getCompanyId());
            searchProjectVo.setOrgId(requestContext.getOrgIds());
            searchProjectVo.setSiteId(requestContext.getSiteId());
        }
        Page<TrainingProjectVo> page = tpProjectClient.listV2(searchProjectVo);
        return BizResponse.ok(page);
    }


    @PostMapping("/up")
    @ApiOperation(value = "启用", notes = "启用操作")
    public Response<String> up(
            @ApiParam(value = "培训项目id参数形式：{\"id\": 1111}", required = true) @RequestBody Map<String, Long> map
    ) {
        try {
            Integer a = tpProjectClient.up(map);
            if (a == -1) {
                return Response.fail(InternationalEnums.TRAININGPROJECTCONTROLLER1.getCode());
            }
        } catch (BizException e) {
            return Response.fail("", e.getMessage());
        }
        return Response.ok();
    }


    @PostMapping("/down")
    @ApiOperation(value = "停用", notes = "停用操作")
    public Response<String> down(
            @ApiParam(value = "培训项目id参数形式：{\"id\": 1111}", required = true) @RequestBody Map<String, Long> map
    ) {
        Long trainingProjectId = map.get("id");
        TrainingProjectVo one = trainingProjectClient.getOne(trainingProjectId);
        //下架前判断是首页已经引用
        if (one != null) {
            ProtalPlateVo protalPlate = new ProtalPlateVo();
            protalPlate.setLinkContent(trainingProjectId);
            protalPlate.setState(1);
            ProtalPlateVo plate = portalManagePCFeignClient.getPlate(protalPlate);
            if (plate != null) {
                LOGGER.info("首页已引用，无法下架！！！");
                return Response.fail(InternationalEnums.TRAININGPROJECTCONTROLLER2.getCode());
            }
        }
        Boolean f = tpProjectClient.down(map);
        if (f) {
            return Response.ok();
        } else {
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @PostMapping("/save")
    @ApiOperation(value = "新增培训项目第一步：基本信息", notes = "返回新增培训项目", response = TrainingProjectVo.class)
    public Response<TrainingProjectVo> save(
            @ApiParam(value = "培训项目分类vo", required = true) @RequestBody TrainingProjectSaveVo vo) {
        try {
            Date date = new Date();
            RequestContext context = ContextHolder.get();

            TrainingProjectVo trainingProject = new TrainingProjectVo();
            // 组织信息
            trainingProject.setCompanyId(context.getCompanyId());
            trainingProject.setSiteId(context.getSiteId());
            trainingProject.setOrgId(context.getOrgId() == null ? new Long(0) : context.getOrgId());
            // 审计字段
            trainingProject.setCreateById(context.getAccountId());
            trainingProject.setCreateByName(context.getAccountName());
            trainingProject.setCreateTime(date);

            trainingProject.setDeleted(ProjectConstant.DELETED_NO);
            trainingProject.setStatus(ProjectConstant.PROJECT_STATUS_DRAFT);

            trainingProject.setDescription(vo.getDescription());
            trainingProject.setEnableEnroll(vo.getEnableEnroll());
            trainingProject.setEnableSign(vo.getEnableSign());
            trainingProject.setEndTime(vo.getEndTime());
            trainingProject.setStartTime(vo.getStartTime());
            trainingProject.setKeyWords(vo.getKeyWords());
            trainingProject.setLogoImg(vo.getLogoImg());
            trainingProject.setName(vo.getName());
            trainingProject.setTpClassificationId(StringUtils.isEmpty(vo.getTpClassificationId()) ? 0 : vo.getTpClassificationId());
            trainingProject.setWeight(vo.getWeight());
            trainingProject.setEnablePosition(vo.getEnablePosition());
            trainingProject.setEnableQueue(vo.getEnableQueue());
            
            //新增字段
            trainingProject.setActivityType(vo.getActivityType());
            trainingProject.setBizType(vo.getBizType());
            trainingProject.setActivityCode(vo.getActivityCode());
            trainingProject.setSubtitle(vo.getSubtitle());
            trainingProject.setPictureSource(vo.getPictureSource());
            trainingProject.setActivityAddress(vo.getActivityAddress());
            trainingProject.setOrganizer(vo.getOrganizer());
            trainingProject.setCoOrganizer(vo.getCoOrganizer());
            trainingProject.setTips(vo.getTips());
            trainingProject.setOther(vo.getOther());
            trainingProject.setTopUp(vo.getTopUp());
            trainingProject.setResearchId(vo.getResearchId());
            trainingProject.setVideoUrl(vo.getVideoUrl());
            trainingProject.setActivityReward(vo.getActivityReward());
            trainingProject.setDetailsImage(vo.getDetailsImage());

            return Response.ok(trainingProjectClient.save(trainingProject));
        } catch (Exception e) {
            LOGGER.error("", e);
            return Response.fail("", e.getLocalizedMessage());
        }
    }

    @PostMapping("/step/three/save")
    @ApiOperation(value = "新增培训项目第三步：可见范围、提醒时间", notes = "返回新增培训项目", response = TrainingProjectVo.class)
    public Response<Integer> saveStepThree(
            @ApiParam("培训项目保存第三步vo") @RequestBody TrainingProjectStepThreeVo vo) {
        try {
            BaseModel<TrainingProjectStepThreeVo> model = new BaseModel<>();
            model.setObj(vo);
            model.setDate(new Date());
            model.setContext(ContextHolder.get());

            int num = 0;

            num = trainingProjectClient.saveStepThree(model);
            if (num == 4000) {
                return Response.fail(InternationalEnums.TRAININGPROJECTCONTROLLER3.getCode());
            }

            if (num >= 1) {
                TrainingProjectVo project = trainingProjectClient.getOne(vo.getTrainingProjectId());
                //调用提醒服务发送服务
//                try {
//                    LOGGER.info("调研调用提醒服务，开始");
//                    //判断是否设置了提醒
//                    TpRemindVo remindVo = vo.getRemindVo();
//                    if (!StringUtils.isEmpty(remindVo)) {
//                        List<TpRemindTimeVo> remindTimeVos = remindVo.getReminds();
//                        if (!CollectionUtils.isEmpty(remindTimeVos)) {
//
//                            Date time = null;
//                            MessageReceiverVO messageReceiverVO = null;
//                            List<MessageVO> messageVOS = new ArrayList<>();
//                            List<TpAuthorizationRange> authorizationRanges = new ArrayList<>();
//
//
//                            for (TpRemindTimeVo timeVo : remindTimeVos) {
//                                time = null;
//                                messageReceiverVO = null;
//
//                                MessageVO messageVO = new MessageVO();
//                                messageVO.setSubject(project.getName());             //消息标题
//                                messageVO.setMessageType(Integer.valueOf(MessageType.TP.getKey())); //消息类型(0自定义消息1学习计划2考试3调研4投票5报名6作业7签到8项目)
//                                messageVO.setTaskId(project.getId());                                    //关联业务id,自定义消息为0
//                                messageVO.setContext(remindVo.getContent());          //消息内容
//
//                                //1开始前发送  2结束前发送  3自定义时间  (发生时间)
//                                messageVO.setAheadType(0);
//                                // 1：开始时间之前
//                                if (timeVo.getType() == 1) {
//                                    time = new Date(project.getStartTime().getTime() + (timeVo.getSeconds() * 1000));
//                                }
//                                // 2：结束时间事前
//                                else if (timeVo.getType() == 2) {
//                                    time = new Date(project.getEndTime().getTime() + (timeVo.getSeconds() * 1000));
//                                }
//                                // 3：自定义时间
//                                else if (timeVo.getType() == 3) {
//                                    time = timeVo.getTime();
//                                } else {
//                                    throw new Exception("未知的提醒时间类型，请检查：1：开始时间之前，2：结束时间事前，3：自定义时间");
//                                }
//                                messageVO.setHappenTime(time);
//
//                                //项目是否 0：指定学员可见，1平台用户可见
//                                if (project.getVisibleRange().equals(1)) {
//                                    messageVO.setVisibleRange(Integer.valueOf(VisibleRange.ALL.getKey()));
//                                } else if (project.getVisibleRange().equals(0)) {
//                                    authorizationRanges = trainingProjectClient.VisibleRange(project.getId());
//                                    if (!CollectionUtils.isEmpty(authorizationRanges)) {
//                                        List<MessageReceiverVO> messageReceiverVOS = new ArrayList<>();
//                                        for (TpAuthorizationRange range : authorizationRanges) {
//                                            messageReceiverVO = new MessageReceiverVO();
//                                            messageReceiverVO.setType(range.getType());
//                                            messageReceiverVO.setReceiverId(range.getRelationId());
//                                            messageReceiverVOS.add(messageReceiverVO);
//                                        }
//
//                                        messageVO.setReceiverVOs(messageReceiverVOS);
//                                    }
//                                }
//
//                                List<Integer> sendTypes = new ArrayList<>();
//                                //添加提醒消息类型
//                                if (remindVo.getEnableMail().equals(1)) {
//                                    sendTypes.add(Integer.parseInt(SendType.MAIL.getCode()));
//                                }
//                                if (remindVo.getEnableApp().equals(1)) {
//                                    sendTypes.add(Integer.parseInt(SendType.APPPUSH.getCode()));
//                                }
//                                messageVO.setSendTypes(sendTypes);
//
//                                messageVOS.add(messageVO);
//                            }
//
//                            systemMessageClient.add(messageVOS);
//                            LOGGER.info("培训项目调用提醒服务，成功");
//                        }
//
//                    } else {
//                        // TODO 删除提醒服务的内容
//                    }
//                } catch (Exception e) {
//                    LOGGER.info("调研调用提醒服务，失败");
//                    e.printStackTrace();
//                }
                return Response.ok(num);
            }
            return Response.ok(num);
        } catch (Exception e) {
            LOGGER.error("", e);
            return Response.fail("", e.getLocalizedMessage());
        }
    }

    /**
     * 新增培训项目--第三步：可见范围、提醒，查看
     *
     * @param id
     * @return
     */
    @GetMapping("/step/three/view")
    @ApiOperation(value = "培训项目第三步：可见范围、提醒时间，查看", response = TrainingProjectStepThreeVo.class)
    public Response<TrainingProjectStepThreeVo> sepThreeView(
            @ApiParam("培训项目id") @RequestParam("id") Long id) {
        try {
            return Response.ok(trainingProjectClient.sepThreeView(id));
        } catch (Exception e) {
            LOGGER.error("", e);
            return Response.fail("", e.getLocalizedMessage());

        }
    }

    @PostMapping("/update")
    @ApiOperation(value = "修改培训项目：基本信息", notes = "返回修改的培训项目", response = TrainingProjectVo.class)
    public Response<TrainingProjectVo> update(
            @ApiParam(value = "培训项目分类vo", required = true) @RequestBody TrainingProjectSaveVo vo) {
        try {
            Date date = new Date();
            RequestContext context = ContextHolder.get();

            TrainingProjectVo trainingProject = new TrainingProjectVo();
            // 审计字段
            trainingProject.setUpdateById(context.getAccountId());
            trainingProject.setUpdateByName(context.getAccountName());
            trainingProject.setUpdateTime(date);

            trainingProject.setId(vo.getId());
            trainingProject.setDescription(vo.getDescription());
            trainingProject.setEnableEnroll(vo.getEnableEnroll());
            trainingProject.setEnableSign(vo.getEnableSign());
            trainingProject.setEndTime(vo.getEndTime());
            trainingProject.setStartTime(vo.getStartTime());
            trainingProject.setKeyWords(vo.getKeyWords());
            trainingProject.setLogoImg(vo.getLogoImg());
            trainingProject.setName(vo.getName());
            trainingProject.setTpClassificationId(vo.getTpClassificationId());
            trainingProject.setWeight(vo.getWeight());
            trainingProject.setEnablePosition(vo.getEnablePosition());
            
            //新增字段
            trainingProject.setActivityType(vo.getActivityType());
            trainingProject.setBizType(vo.getBizType());
            trainingProject.setActivityCode(vo.getActivityCode());
            trainingProject.setSubtitle(vo.getSubtitle());
            trainingProject.setPictureSource(vo.getPictureSource());
            trainingProject.setActivityAddress(vo.getActivityAddress());
            trainingProject.setOrganizer(vo.getOrganizer());
            trainingProject.setCoOrganizer(vo.getCoOrganizer());
            trainingProject.setTips(vo.getTips());
            trainingProject.setOther(vo.getOther());
            trainingProject.setTopUp(vo.getTopUp());
            trainingProject.setResearchId(vo.getResearchId());
            trainingProject.setVideoUrl(vo.getVideoUrl());
            trainingProject.setActivityReward(vo.getActivityReward());
            trainingProject.setDetailsImage(vo.getDetailsImage());
            
            return Response.ok(trainingProjectClient.update(trainingProject));
        } catch (Exception e) {
            LOGGER.error("", e);
            return Response.fail("", e.getLocalizedMessage());
        }
    }

    @PostMapping("/delete")
    @ApiOperation(value = "删除培训项目")
    public Response update(
            @ApiParam(value = "培训项目id集合", required = true) @RequestBody List<String> ids) {
        try {
            List<Long> longIds = new ArrayList<Long>();
            for (String id : ids) {
                longIds.add(Long.valueOf(id));
            }
            BaseModel<List<Long>> model = new BaseModel<>();
            model.setContext(ContextHolder.get());
            model.setDate(new Date());
            model.setObj(longIds);

            return Response.ok(trainingProjectClient.batchDelete(model));
        } catch (Exception e) {
            LOGGER.error("", e);
            return Response.fail("", e.getLocalizedMessage());
        }

    }

    @PostMapping("/visibleRange/set")
    @ApiOperation(value = "设置可见范围")
    public Response<Integer> setVisibleRange(
            @ApiParam("可见范围集合") @RequestBody VisibleRangeVo vo) {
        try {
            BaseModel<VisibleRangeVo> model = new BaseModel<>();
            model.setObj(vo);
            model.setContext(ContextHolder.get());
            model.setDate(new Date());
            return Response.ok(trainingProjectClient.setVisibleRange(model));
        } catch (Exception e) {
            LOGGER.error("", e);
            return Response.fail("", e.getLocalizedMessage());
        }
    }

    @GetMapping("/visibleRange/view")
    @ApiOperation(value = "查看可见范围", response = TpAuthorizationRangeVo.class)
    public Response<List<TpAuthorizationRangeVo>> VisibleRange(
            @ApiParam("培训项目id") @RequestParam Long trainingProjectId) {
        try {
            List<TpAuthorizationRangeVo> ranges = trainingProjectClient.VisibleRange(trainingProjectId);
            //实时获取
            if (!CollectionUtils.isEmpty(ranges)) {
                List<Long> accountIds = new ArrayList<>(ranges.size());
                List<Long> orgIds = new ArrayList<>(ranges.size());
                ranges.forEach(a -> {
                    if (a.getType().equals(1)) {
                        orgIds.add(a.getRelationId());
                    } else {
                        accountIds.add(a.getRelationId());
                    }
                });
                Map<Long, AccountVO> accountMap = queryAccount.queryAccountByIds(accountIds);
                Map<Long, OrgVO> orgMap = queryAccount.queryOrgByIds(orgIds);
                ranges.forEach(a -> {
                    if (null != accountMap) {
                        AccountVO accountVO = accountMap.get(a.getRelationId());
                        if (null != accountVO && a.getType().equals(2)) {
                            a.setWorkNum(accountVO.getWorkNum());
                            a.setFullName(accountVO.getFullName());
                            a.setName(accountVO.getName());
                        }
                    }
                    if (null != orgMap) {
                        OrgVO orgVO = orgMap.get(a.getRelationId());
                        if (null != orgVO && a.getType().equals(1)) {
                            a.setName(orgVO.getName());
                        }
                    }
                });
            }
            return Response.ok(ranges);
        } catch (Exception e) {
            LOGGER.error("", e);
            return Response.fail("", e.getLocalizedMessage());
        }
    }

    @GetMapping("/one/get")
    @ApiOperation(value = "查看培训项目详情", response = TrainingProjectVo.class)
    public Response<TrainingProjectVo> getOne(
            @ApiParam("培训项目id") @RequestParam Long trainingProjectId
    ) {
        try {
            return Response.ok(trainingProjectClient.getOne(trainingProjectId));
        } catch (Exception e) {
            LOGGER.error("", e);
            return Response.fail("", e.getLocalizedMessage());
        }

    }

    @GetMapping("/cache/init")
    public Response<Boolean> cacheInit(@RequestParam(name = "subDate", required = false) Date subDate) {
        return Response.ok(trainingProjectClient.cacheInit(subDate));
    }

    @GetMapping("/record/cache/init")
    public Response<Boolean> recordInit() {
        return Response.ok(trainingProjectClient.recordInit());
    }

    /**
     * 签到记录导出
     *
     * @param trainingProjectId
     * @return
     * @author ding
     */
    @GetMapping("/exportSignRecord")
    public Response<String> exportSignRecord(@ApiParam(name = "trainingProjectId", required = true) @RequestParam(name = "trainingProjectId") Long trainingProjectId) {
        String serialNo = signRecordApiClient.exportSignRecord(trainingProjectId);

        TrainingProjectVo vo = trainingProjectClient.getOne(trainingProjectId);

        String fileName = vo.getName() + "签到记录明细表" + serialNo + ".xlsx";

        String fileUril = pcHostUrl+"/api/v1/buckets/upload/objects/download/?preview=true&prefix="+fileName;
        return Response.ok(fileUril);
    }
}
