package com.yizhi.application.rangeImport;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.system.application.model.AccountRangeImportModel;
import com.yizhi.system.application.model.AccountRangeImportParam;
import com.yizhi.system.application.system.remote.AccountRangeClient;
import com.yizhi.training.application.feign.TrainingProjectClient;
import com.yizhi.training.application.vo.domain.TpAuthorizationRangeVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Auther: dingxiaowei
 * @Date: 2018/9/17 16:47
 * @Description:报名可见范围异步导入
 */
@Component
public class TrainingProjectRangeImport extends AbstractDefaultTask<String, Map<String, Object>> {

    private static final Logger LOGGER = LoggerFactory.getLogger(TrainingProjectRangeImport.class);

    @Autowired
    private AccountRangeClient accountRangeClient;

    @Autowired
    private TrainingProjectClient trainingProjectClient;

    @Autowired
    private RangeUtil importUtil;

    @Override
    protected String execute(Map<String, Object> map) {

        //从map中取值
        String ossUrl = (String) map.get("ossUrl");
        RequestContext res = (RequestContext) map.get("requestContext");
        Long projectId = (Long) map.get("projectId");
        Long accountId = res.getAccountId();
        Long siteId = res.getSiteId();
        Long companyId = res.getCompanyId();
        Date submitTime = new Date();
        Long taskId = (Long) map.get("taskId");
        String serialNo = (String) map.get("serialNo");
        String taskName = (String) map.get("taskName");
        TaskContext taskContext = new TaskContext(taskId, serialNo, taskName, accountId, submitTime, siteId, companyId);
        working(taskContext);

        String accountFullName = res.getAccountFullName();
        //将请求值装入param
        AccountRangeImportParam param = new AccountRangeImportParam();
        param.setType(AccountRangeImportParam.Type.TRAININGPROJECT);
        param.setOssUrl(ossUrl);
        param.setRequestContext(res);
        List<AccountRangeImportModel.SuccessAccount> successList = null;
        List<AccountRangeImportModel.ErrorAccount> errorList = null;
        List<Integer> integerList = null;
        //进行入库
        try {
            AccountRangeImportModel accountRangeImportModel = accountRangeClient.doImport(param);
            if (null != accountRangeImportModel) {
                successList = accountRangeImportModel.getSuccessList();
                errorList = accountRangeImportModel.getErrorList();
            }

            errorList = (errorList == null ? new ArrayList<>() : errorList);
            successList = (successList == null ? new ArrayList<>() : successList);
            List<TpAuthorizationRangeVo> tpAuthorizationRanges = new ArrayList<>();

            TpAuthorizationRangeVo tpAuthorizationRange = null;
            if (!CollectionUtils.isEmpty(successList)) {
                for (AccountRangeImportModel.SuccessAccount rangeImportModel : successList) {
                    tpAuthorizationRange = new TpAuthorizationRangeVo();
                    tpAuthorizationRange.setBizId(projectId);
                    tpAuthorizationRange.setType(2);
                    tpAuthorizationRange.setRelationId(rangeImportModel.getId());
                    tpAuthorizationRange.setName(rangeImportModel.getName());
                    tpAuthorizationRange.setSiteId(siteId);
                    tpAuthorizationRanges.add(tpAuthorizationRange);
                }
                trainingProjectClient.insertVisibleRange(tpAuthorizationRanges);
            }


            importUtil.returnResults(taskContext, successList, errorList, ossUrl);

        } catch (Exception e) {
            e.printStackTrace();
            fail(taskContext, "培训项目可见范围异步导入过程中出现错误:");
            LOGGER.error("培训项目可见范围异步导入过程中出现错误", e);
        }

        return "ok";
    }
}
