package com.yizhi.application.outside;

import com.alibaba.fastjson.JSON;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.course.application.feign.OutsideEbscnCourseClient;
import com.yizhi.course.application.vo.OutsideEbscnCourseRecordVO;
import com.yizhi.course.application.vo.OutsideEbscnCourseVO;
import com.yizhi.system.application.system.remote.OutsideSystemClient;
import com.yizhi.system.application.vo.OutsideUserVO;
import com.yizhi.system.application.vo.domain.SwhyKey;
import com.yizhi.training.application.feign.OutsideTrainingProjectEbscnClient;
import com.yizhi.training.application.vo.api.TpStudentProjectRecordEbscnVO;
import com.yizhi.training.application.vo.api.UserTrainingProjectStatusVO;
import com.yizhi.training.application.vo.domain.TpStudentProjectRecordVo;
import com.yizhi.util.application.domain.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 外部系统光大证券的相关接口
 */
@RestController
@RequestMapping("/public/api/outside/ebscn")
public class OutsideEbscnController {

    @Autowired
    OutsideSystemClient outsideSystemClient;

    @Autowired
    OutsideTrainingProjectEbscnClient outsideTrainingProjectEbscnClient;

    @Autowired
    OutsideEbscnCourseClient outsideEbscnCourseClient;

    public static final Logger LOGGER = LoggerFactory.getLogger(OutsideEbscnController.class);

    /**
     * 岗前60小时学习记录的接口api
     * @return
     */
    @GetMapping("/learn/records/get")
    public Response getLearnRecords(@RequestParam("appId") String appId){

        RequestContext context = ContextHolder.get();
        // 获取企业id和站点id
        Long siteId = context.getSiteId();
        String siteCode = context.getSiteCode();
        Long companyId = context.getCompanyId();
        String companyCode = context.getCompanyCode();
        // 获取appId的配置
        SwhyKey swhyKey = outsideSystemClient.getSwhyKeyConfig(appId, companyId);
        if(swhyKey == null){
            return Response.fail("appId无效");
        }

        // 获取该企业站点下的待入职人员
        List<OutsideUserVO> users = outsideSystemClient.getRcUsers("", companyId, siteId.toString());
        LOGGER.info("{}站点下的待入职人员={}", siteId, JSON.toJSONString(users));

        if(!CollectionUtils.isEmpty(users)){
            UserTrainingProjectStatusVO voReq = new UserTrainingProjectStatusVO();
            voReq.setSiteId(siteId);
            voReq.setTrainingProjectName("岗前60小时");
            // 设置用户id
            voReq.setUserIds(users.stream().map(itemObj -> itemObj.getId()).collect(Collectors.toList()));
            TpStudentProjectRecordEbscnVO data = outsideTrainingProjectEbscnClient.geUserTrainingProjectStatus(voReq);

            Map<Long, OutsideUserVO> userMap = users.stream().collect(Collectors.toMap(keyObj->keyObj.getId(), valObj -> valObj));
            List<OutsideEbscnCourseRecordVO> retData = new ArrayList<>();
            for(Map.Entry<Long, OutsideUserVO> item : userMap.entrySet()){
                OutsideEbscnCourseRecordVO vo = new OutsideEbscnCourseRecordVO();
                vo.setName(item.getValue().getName());
                vo.setPassed(0);
                vo.setTrainhours(0f);
                retData.add(vo);
            }

            LOGGER.info("岗前60小时关联的课程列表={}", JSON.toJSONString(data));
            if( data != null){
                List<TpStudentProjectRecordVo> tsprData = data.getData();
                Map<Long, TpStudentProjectRecordVo> tpStudentProjectRecordMap = null;
                if(!CollectionUtils.isEmpty(tsprData)){
                    tpStudentProjectRecordMap = tsprData.parallelStream().collect(Collectors.toMap(tpKey -> tpKey.getAccountId(), tpVal -> tpVal));
                }

                // 查询用户状态
                // SELECT * FROM course_student_status WHERE site_id = 113 AND company_id = 40 AND student_status = 1 course_id IN() AND account_id IN()
                OutsideEbscnCourseVO outsideEbscnCourseVO = new OutsideEbscnCourseVO();
                outsideEbscnCourseVO.setSiteId(siteId);
                outsideEbscnCourseVO.setCourseIds(data.getCourseIds());
                outsideEbscnCourseVO.setAccountIds(new ArrayList<>(userMap.keySet())); // 按用户待入职维度查询
                // 查询用户的学习学时情况
                List<OutsideEbscnCourseRecordVO> outsideEbscnCourseRecordVOS = outsideEbscnCourseClient
                        .getStudyRecord(outsideEbscnCourseVO);
                Map<String, OutsideEbscnCourseRecordVO> outsideEbscnCourseRecordVOMap = null;
                if(!CollectionUtils.isEmpty(outsideEbscnCourseRecordVOS)){
                    outsideEbscnCourseRecordVOMap = outsideEbscnCourseRecordVOS.stream().collect(Collectors.toMap(oecKey -> oecKey.getName(), oecVal -> oecVal));
                }

                retData = new ArrayList<>();
                for(Map.Entry<Long, OutsideUserVO> item : userMap.entrySet()){
                    Long accountId = item.getKey();
                    OutsideEbscnCourseRecordVO vo = new OutsideEbscnCourseRecordVO();
                    vo.setName(item.getValue().getName());
                    vo.setPassed(0);
                    if(tpStudentProjectRecordMap != null && tpStudentProjectRecordMap.containsKey(accountId)){
                        vo.setPassed(tpStudentProjectRecordMap.get(accountId).getFinished());
                    }
                    vo.setTrainhours(0f);
                    if(outsideEbscnCourseRecordVOMap != null && outsideEbscnCourseRecordVOMap.containsKey(accountId.toString())){
                        vo.setTrainhours(outsideEbscnCourseRecordVOMap.get(accountId.toString()).getTrainhours());
                    }
                    retData.add(vo);
                }

            }
            return Response.ok(retData);
        }

        return Response.ok();
    }
}
