package com.yizhi.application.inform;


import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.accountUtil.AuthorizeQueryAccount;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.comment.application.constans.Constant;
import com.yizhi.comment.application.feign.InformRecordClient;
import com.yizhi.comment.application.vo.InformCommentVo;
import com.yizhi.comment.application.vo.InformRecordVo;
import com.yizhi.forum.application.feign.PostsForbiddenAccountClient;
import com.yizhi.forum.application.vo.domain.PostsForbiddenAccountVo;
import com.yizhi.system.application.vo.AccountVO;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.*;
import java.util.stream.Collectors;

@Api(tags = "管理端-举报接口")
@RestController
@RequestMapping("/manage/inform")
public class InformController {

    private static final Logger LOG = LoggerFactory.getLogger(InformController.class);


    @Autowired
    private InformRecordClient informRecordClient;
    @Autowired
    private PostsForbiddenAccountClient postsForbiddenAccountClient;
    @Autowired
    private AuthorizeQueryAccount queryAccount;


    @GetMapping("/getPage")
    @ApiOperation(value = "获取举报记录列表 ")
    public Response<Object> getPage(@ApiParam("业务类型 1-帖子 2-评论回复") @RequestParam("taskType") Integer taskType,
                                    @ApiParam("业务id taskType=2时，为帖子id ") @RequestParam("taskId") Long taskId,
                                    @ApiParam("type  0-帖子 1-评论") @RequestParam(value = "type") Integer type,
                                    @ApiParam("终端类型：1-管理端   2-pc端   3-微信端  4-app") @RequestParam("terminalType") Integer terminalType,
                                    @ApiParam("页码") @RequestParam(value = "pageNo", defaultValue = "1") Integer pageNo,
                                    @ApiParam("页面条数") @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize) {

        Page<InformRecordVo> page = informRecordClient.getPage(taskType, taskId, type, terminalType, pageNo, pageSize);
        List<InformRecordVo> records = page.getRecords();
        if (!CollectionUtils.isEmpty(records)) {
            List<Long> forbiddenAccountIds = null;
            Set<Long> accountIds = new HashSet<>(records.size());
            //如果是举报的回复列表执行
            if (Constant.TASK_TYPE_COMMENT_REPLY.equals(type)) {
                //获取禁言名单
                Page<PostsForbiddenAccountVo> page1 = postsForbiddenAccountClient.getPage(taskId, 1, Integer.MAX_VALUE);
                List<PostsForbiddenAccountVo> forbiddenAccounts = page1.getRecords();
                if (!CollectionUtils.isEmpty(forbiddenAccounts)) {
                    forbiddenAccountIds = forbiddenAccounts.stream().map(a -> a.getAccountId()).collect(Collectors.toList());
                }
            }
            //实时获取用户名
            records.forEach(a -> {
                accountIds.add(a.getCreateById());
                if (a.getInformCommentVo() != null) {
                    accountIds.add(a.getInformCommentVo().getAccountId());
                }
            });
            Map<Long, AccountVO> accountMap = queryAccount.queryAccountByIds(new ArrayList<>(accountIds));
            for (InformRecordVo a : records) {

                InformCommentVo commentVo = a.getInformCommentVo();
                if (commentVo != null) {
                    if (accountMap != null) {
                        AccountVO accountVO = accountMap.get(commentVo.getAccountId());
                        if (accountVO != null) {
                            commentVo.setCommentator(accountVO.getName());
                        }
                    }
                    commentVo.setStatus("未禁言");
                    if (!CollectionUtils.isEmpty(forbiddenAccountIds)) {
                        if (forbiddenAccountIds.contains(commentVo.getAccountId())) {
                            commentVo.setHasForbidden(true);
                            commentVo.setStatus("已禁言");
                        }
                    }
                }
            }
        }
        return Response.ok(page);
    }

    @GetMapping("/cancel")
    @ApiOperation(value = "移除举报 ")
    public Response<Object> getPage(@ApiParam("举报记录id") @RequestParam("id") Long id) {
        Integer cancel = informRecordClient.cancel(id);
        if (cancel == 1) {
            return Response.ok("操作成功！");
        }
        return Response.fail(InternationalEnums.INFORMCONTROLLER.getCode());
    }


}

