
package com.yizhi.application.report.trainingproject;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.statistics.application.feign.StatisticsTrainingClient;
import com.yizhi.statistics.application.refactor.*;
import com.yizhi.statistics.application.training.vo.TrainingProjectGroupParam;
import com.yizhi.training.application.vo.manage.TrainingProjectDataChartsVo;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 培训项目报表统计
 * @author mei
 *
 */

@Api(tags = "报表统计-培训项目", description = "报表统计-培训项目")
@RestController
@RequestMapping("/manage/report/trainingproject")
public class ReportTrainingProject2 {
	
	private Logger logger = LoggerFactory.getLogger(ReportTrainingProject2.class);
	
	@Autowired
	private StatisticsTrainingClient statisticsTrainingClient;
	
	
	@ApiOperation(value = "图表数据统计", notes = "图表数据统计", response = TrainingProjectDataChartsVo.class)
    @GetMapping("/chart/group")
    public Response<TrainingProjectDataChartsVo> chartGroup(
    		@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate, 
    		@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate){
		RequestContext requestContext = ContextHolder.get();
		Long companyId = requestContext.getCompanyId();
		Long siteId =requestContext.getSiteId();
		Long adminId=requestContext.getAccountId();
		Boolean isAdmin=requestContext.isAdmin();
		TrainingProjectGroupParam trainingGroupParam=new TrainingProjectGroupParam();
		trainingGroupParam.setStartDate(startDate);
		trainingGroupParam.setEndDate(endDate);
		trainingGroupParam.setCompanyId(companyId);
		trainingGroupParam.setSiteId(siteId);
		trainingGroupParam.setAdminId(adminId);
		trainingGroupParam.setIsAdmin(isAdmin);
		logger.info("companyId:{}",companyId);
		logger.info("siteId:{}",siteId);
		logger.info("adminId:{}",adminId);
		logger.info("isAdmin:{}",isAdmin);
		List<TrainingProjectDataChartsVO> list=statisticsTrainingClient.chartGroup(trainingGroupParam);
		return Response.ok(list);
	}
	
	

	@ApiOperation(value = "按项目统计", notes = "按项目统计", response = ReportStudyTrainingProjectVo.class)
    @GetMapping("/group")
    public Response<ReportStudyTrainingProjectVo> trainingProjectGroup(
    		@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate, 
    		@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate, 
    		@ApiParam(value = "项目名称关键字", required = false) @RequestParam(name = "kwd", required = false) String kwd,     		 
    		@ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
    		@ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo){
		RequestContext requestContext = ContextHolder.get();
		Long companyId = requestContext.getCompanyId();
		Long siteId =requestContext.getSiteId();
		Long adminId=requestContext.getAccountId();
		Boolean isAdmin=requestContext.isAdmin();
		TrainingProjectGroupParam trainingGroupParam=new TrainingProjectGroupParam();
		trainingGroupParam.setStartDate(startDate);
		trainingGroupParam.setEndDate(endDate);
		trainingGroupParam.setKwd(kwd);
		trainingGroupParam.setPageNo(pageNo);
		trainingGroupParam.setPageSize(pageSize);
		trainingGroupParam.setCompanyId(companyId);
		trainingGroupParam.setSiteId(siteId);
		trainingGroupParam.setAdminId(adminId);
		trainingGroupParam.setIsAdmin(isAdmin);
		Page<ReportStudyTrainingProjectVo> page = statisticsTrainingClient.trainingGroup(trainingGroupParam);
		Map<String, Integer> pageMap = new HashMap<String, Integer>();
		Integer total=0;
		List<ReportStudyTrainingProjectVo> list=null;
		if(page!=null) {
			total=page.getTotal();
			list=page.getRecords();
		}
		pageMap.put("pageNo", pageNo);
		pageMap.put("pageSize", pageSize);
		pageMap.put("pageTotal", total);
		return Response.ok(list, pageMap);
	}
	
	
	

	@ApiOperation(value = "按项目统计导出记录", notes = "按项目统计导出记录", response = ReportStudyTrainingProjectVo.class)	
    @GetMapping("/group/export")
    public Response<ReportStudyTrainingProjectVo> trainingProjectGroupExport(
    		@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate, 
    		@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate, 
    		@ApiParam(value = "项目名称关键字", required = false) @RequestParam(name = "kwd", required = false) String kwd){
		
		Date submitTime = new Date();
		Long taskId = submitTime.getTime();
		String serialNo="USER-EXPORT-"+taskId;
		String taskName="学习项目-按项目统计-下载结果数据-"+taskId;
		RequestContext requestContext = ContextHolder.get();
		Long companyId = requestContext.getCompanyId();
		Long siteId =requestContext.getSiteId();
		Long adminId=requestContext.getAccountId();
		Boolean isAdmin=requestContext.isAdmin();
		TrainingProjectGroupParam trainingGroupParam=new TrainingProjectGroupParam();
		trainingGroupParam.setStartDate(startDate);
		trainingGroupParam.setEndDate(endDate);
		trainingGroupParam.setKwd(kwd);
		trainingGroupParam.setCompanyId(companyId);
		trainingGroupParam.setSiteId(siteId);
		trainingGroupParam.setAdminId(adminId);
		trainingGroupParam.setIsAdmin(isAdmin);
		trainingGroupParam.setSerialNo(serialNo);
		trainingGroupParam.setTaskId(taskId);
		trainingGroupParam.setSubmitTime(submitTime);
		trainingGroupParam.setTaskName(taskName);
		statisticsTrainingClient.trainingGroupExcel(trainingGroupParam);
		return Response.ok("任务编号："+serialNo+"。任务名称："+taskName);
	}
	
	
	
	@ApiOperation(value = "按项目统计-查看", notes = "按项目统计-查看", response = TrainingProjectDataChartsVo.class)	
    @GetMapping("/group/view")
    public Response<TrainingProjectDataChartsVo> trainingProjectGroupView(
    		@ApiParam(value = "项目ID", required = true) @RequestParam(name = "projectId", required = true) Long projectId,     	
    		@ApiParam(value = "每页条数", required = false) @RequestParam(name = "pageSize", required = false) Integer pageSize,
    		@ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false,defaultValue="1") Integer pageNo){
		if(pageSize==null) {
			pageSize=2000; //现在估计一个培训项目最多挂靠2000个活动，分页查询
		}
		RequestContext requestContext = ContextHolder.get();
		Long companyId = requestContext.getCompanyId();
		Long siteId =requestContext.getSiteId();
		Long adminId=requestContext.getAccountId();
		Boolean isAdmin=requestContext.isAdmin();
		TrainingProjectGroupParam trainingGroupParam=new TrainingProjectGroupParam();
		trainingGroupParam.setPageNo(pageNo);
		trainingGroupParam.setPageSize(pageSize);
		trainingGroupParam.setCompanyId(companyId);
		trainingGroupParam.setSiteId(siteId);
		trainingGroupParam.setAdminId(adminId);
		trainingGroupParam.setIsAdmin(isAdmin);
		trainingGroupParam.setProjectId(projectId);
		Page<TrainingProjectDataChartsVO> page= statisticsTrainingClient.trainingProjectGroupView(trainingGroupParam);
		Map<String, Integer> pageMap = new HashMap<String, Integer>();
		Integer total=0;
		List<TrainingProjectDataChartsVO> list=null;
		if(page!=null) {
			total=page.getTotal();
			list=page.getRecords();
		}
		pageMap.put("pageNo", pageNo);
		pageMap.put("pageSize", pageSize);
		pageMap.put("pageTotal", total);
		return Response.ok(list, pageMap);
	}
	
	
	@ApiOperation(value = "按项目统计-查看-下载项目学习结果-导出记录", notes = "按项目统计-查看-下载项目学习结果-导出记录")	
    @GetMapping("/group/view/export1")
    public Response<String> trainingProjectGroupViewExport1(
    		@ApiParam(value = "项目ID", required = true) @RequestParam(name = "projectId", required = true) Long projectId){
		Date submitTime = new Date();
		Long taskId = submitTime.getTime();
		String serialNo="USER-EXPORT-"+taskId;
		String taskName="学习项目-按项目统计-查看-下载项目学习结果-导出记录-"+taskId;
		RequestContext requestContext = ContextHolder.get();
		Long companyId = requestContext.getCompanyId();
		Long siteId =requestContext.getSiteId();
		Long adminId=requestContext.getAccountId();
		Boolean isAdmin=requestContext.isAdmin();
		TrainingProjectGroupParam trainingGroupParam=new TrainingProjectGroupParam();
		trainingGroupParam.setCompanyId(companyId);
		trainingGroupParam.setSiteId(siteId);
		trainingGroupParam.setAdminId(adminId);
		trainingGroupParam.setIsAdmin(isAdmin);
		trainingGroupParam.setSerialNo(serialNo);
		trainingGroupParam.setTaskId(taskId);
		trainingGroupParam.setSubmitTime(submitTime);
		trainingGroupParam.setTaskName(taskName);
		trainingGroupParam.setProjectId(projectId);
		statisticsTrainingClient.trainingProjectGroupViewExcel1(trainingGroupParam);
		return Response.ok("任务编号："+serialNo+"。任务名称："+taskName);
	}
	
	
	
	
	@ApiOperation(value = "按项目统计-查看-学习计划明细-导出记录", notes = "按项目统计-查看-学习计划明细-导出记录")	
    @GetMapping("/group/view/export2")
    public Response<String> trainingProjectGroupViewExport2(@ApiParam(value = "项目ID", required = true) @RequestParam(name = "projectId", required = true) Long projectId){
		Date submitTime = new Date();
		Long taskId = submitTime.getTime();
		String serialNo="USER-EXPORT-"+taskId;
		String taskName="学习项目-按项目统计-查看-学习计划明细-导出记录-"+taskId;
		RequestContext requestContext = ContextHolder.get();
		Long companyId = requestContext.getCompanyId();
		Long siteId =requestContext.getSiteId();
		Long adminId=requestContext.getAccountId();
		Boolean isAdmin=requestContext.isAdmin();
		TrainingProjectGroupParam trainingGroupParam=new TrainingProjectGroupParam();
		trainingGroupParam.setCompanyId(companyId);
		trainingGroupParam.setSiteId(siteId);
		trainingGroupParam.setAdminId(adminId);
		trainingGroupParam.setIsAdmin(isAdmin);
		trainingGroupParam.setSerialNo(serialNo);
		trainingGroupParam.setTaskId(taskId);
		trainingGroupParam.setSubmitTime(submitTime);
		trainingGroupParam.setTaskName(taskName);
		trainingGroupParam.setProjectId(projectId);
		statisticsTrainingClient.trainingProjectGroupViewExcel2(trainingGroupParam);
		return Response.ok("任务编号："+serialNo+"。任务名称："+taskName);
	}
	
	
	@ApiOperation(value = "按项目统计-查看-学员学习明细-导出记录", notes = "按项目统计-查看-学员学习明细-导出记录")	
    @GetMapping("/group/view/export3")
    public Response<String> trainingProjectGroupViewExport4(@ApiParam(value = "项目ID", required = true) @RequestParam(name = "projectId", required = true) Long projectId){
		Date submitTime = new Date();
		Long taskId = submitTime.getTime();
		String serialNo="USER-EXPORT-"+taskId;
		String taskName="学习项目-按项目统计-查看-学员学习明细-导出记录-"+taskId;
		RequestContext requestContext = ContextHolder.get();
		Long companyId = requestContext.getCompanyId();
		Long siteId =requestContext.getSiteId();
		Long adminId=requestContext.getAccountId();
		Boolean isAdmin=requestContext.isAdmin();
		TrainingProjectGroupParam trainingGroupParam=new TrainingProjectGroupParam();
		trainingGroupParam.setCompanyId(companyId);
		trainingGroupParam.setSiteId(siteId);
		trainingGroupParam.setAdminId(adminId);
		trainingGroupParam.setIsAdmin(isAdmin);
		trainingGroupParam.setSerialNo(serialNo);
		trainingGroupParam.setTaskId(taskId);
		trainingGroupParam.setSubmitTime(submitTime);
		trainingGroupParam.setTaskName(taskName);
		trainingGroupParam.setProjectId(projectId);
		statisticsTrainingClient.trainingProjectGroupViewExcel3(trainingGroupParam);
		return Response.ok("任务编号："+serialNo+"。任务名称："+taskName);
	}
	
	
	
	
	@ApiOperation(value = "按用户统计", notes = "按用户统计", response = ReportStudyTrainingProjectAccountVo.class)
    @GetMapping("/account/group")
    public Response<ReportStudyTrainingProjectAccountVo> trainingProjectAccountGroup(
    		@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate, 
    		@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate, 
    		@ApiParam(value = "部门编码或名称", required = false) @RequestParam(name = "orgKwd", required = false) String orgKwd,    
    		@ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountKwd", required = false) String accountKwd,    
    		@ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
    		@ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo){
		RequestContext requestContext = ContextHolder.get();
		Long companyId = requestContext.getCompanyId();
		Long siteId =requestContext.getSiteId();
		Long adminId=requestContext.getAccountId();
		Boolean isAdmin=requestContext.isAdmin();
		TrainingProjectGroupParam trainingGroupParam=new TrainingProjectGroupParam();
		trainingGroupParam.setStartDate(startDate);
		trainingGroupParam.setEndDate(endDate);
		trainingGroupParam.setPageNo(pageNo);
		trainingGroupParam.setPageSize(pageSize);
		trainingGroupParam.setCompanyId(companyId);
		trainingGroupParam.setSiteId(siteId);
		trainingGroupParam.setAdminId(adminId);
		trainingGroupParam.setIsAdmin(isAdmin);
		trainingGroupParam.setOrgKwd(orgKwd);
		trainingGroupParam.setAccountKwd(accountKwd);
		Page<ReportStudyTrainingProjectAccountVo> page = statisticsTrainingClient.trainingProjectAccountGroup(trainingGroupParam);
		Map<String, Integer> pageMap = new HashMap<String, Integer>();
		Integer total=0;
		List<ReportStudyTrainingProjectAccountVo> list=null;
		if(page!=null) {
			total=page.getTotal();
			list=page.getRecords();
		}
		pageMap.put("pageNo", pageNo);
		pageMap.put("pageSize", pageSize);
		pageMap.put("pageTotal", total);
		return Response.ok(list, pageMap);
	}
	
	
	
	
	
	@ApiOperation(value = "按用户统计导出记录", notes = "按用户统计导出记录", response = ReportStudyTrainingProjectVo.class)	
    @GetMapping("/account/group/export")
    public Response<ReportStudyTrainingProjectAccountVo> trainingProjectAccountGroupExport(

    		@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate, 
    		@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate, 
    		@ApiParam(value = "部门编码或名称", required = false) @RequestParam(name = "orgKwd", required = false) String orgKwd,    
    		@ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountKwd", required = false) String accountKwd){
		
		Date submitTime = new Date();
		Long taskId = submitTime.getTime();
		String serialNo="USER-EXPORT-"+taskId;
		String taskName="学习项目-按用户统计-下载结果数据-"+taskId;
		RequestContext requestContext = ContextHolder.get();
		Long companyId = requestContext.getCompanyId();
		Long siteId =requestContext.getSiteId();
		Long adminId=requestContext.getAccountId();
		Boolean isAdmin=requestContext.isAdmin();
		TrainingProjectGroupParam trainingGroupParam=new TrainingProjectGroupParam();
		trainingGroupParam.setCompanyId(companyId);
		trainingGroupParam.setSiteId(siteId);
		trainingGroupParam.setAdminId(adminId);
		trainingGroupParam.setStartDate(startDate);
		trainingGroupParam.setEndDate(endDate);
		trainingGroupParam.setIsAdmin(isAdmin);
		trainingGroupParam.setSerialNo(serialNo);
		trainingGroupParam.setTaskId(taskId);
		trainingGroupParam.setSubmitTime(submitTime);
		trainingGroupParam.setTaskName(taskName);
		trainingGroupParam.setAccountKwd(accountKwd);
		trainingGroupParam.setOrgKwd(orgKwd);
		trainingGroupParam.setAccountKwd(accountKwd);
		statisticsTrainingClient.trainingProjectAccountGroupExcel(trainingGroupParam);
		return Response.ok("任务编号："+serialNo+"。任务名称："+taskName);
	}
	
	
	
	
	@ApiOperation(value = "按用户统计-查看", notes = "按用户统计-查看", response = ReportStudyTrainingProjectAccountViewVo.class)
    @GetMapping("/account/group/view")
    public Response<ReportStudyTrainingProjectAccountViewVo> trainingProjectAccountGroupView(
    		@ApiParam(value = "用户ID", required = true) @RequestParam(name = "accountId", required = true) Long accountId,
    		@ApiParam(value=  "项目关键字",required=false) @RequestParam(name = "projectName", required = false) String projectName,
    		@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate, 
    		@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate, 
    		@ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
    		@ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo){
	
		RequestContext requestContext = ContextHolder.get();
		Long companyId = requestContext.getCompanyId();
		Long siteId =requestContext.getSiteId();
		Long adminId=requestContext.getAccountId();
		Boolean isAdmin=requestContext.isAdmin();
		TrainingProjectGroupParam trainingGroupParam=new TrainingProjectGroupParam();
		trainingGroupParam.setStartDate(startDate);
		trainingGroupParam.setEndDate(endDate);
		trainingGroupParam.setPageNo(pageNo);
		trainingGroupParam.setPageSize(pageSize);
		trainingGroupParam.setCompanyId(companyId);
		trainingGroupParam.setSiteId(siteId);
		trainingGroupParam.setAdminId(adminId);
		trainingGroupParam.setIsAdmin(isAdmin);
		trainingGroupParam.setAccountId(accountId);
		trainingGroupParam.setProjectName(projectName);
		
		Page<ReportStudyTrainingProjectAccountViewVo> page=statisticsTrainingClient.trainingProjectAccountGroupView(trainingGroupParam);
		Map<String, Integer> pageMap = new HashMap<String, Integer>();
		Integer total=0;
		List<ReportStudyTrainingProjectAccountViewVo> list=null;
		if(page!=null) {
			total=page.getTotal();
			list=page.getRecords();
		}
		pageMap.put("pageNo", pageNo);
		pageMap.put("pageSize", pageSize);
		pageMap.put("pageTotal", total);
		return Response.ok(list, pageMap);
	}
	
	

	@ApiOperation(value = "按用户统计-查看-导出记录", notes = "按用户统计--查看-导出记录", response = ReportStudyTrainingProjectVo.class)	
    @GetMapping("/account/group/view/export")
    public Response<ReportStudyTrainingProjectAccountViewVo> trainingProjectAccountGroupViewExport(
    		@ApiParam(value = "用户ID", required = false) @RequestParam(name = "accountId", required = false) Long accountId,
    		@ApiParam(value=  "项目关键字",required=false) @RequestParam(name = "projectName", required = false) String projectName,
    		@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate, 
    		@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate){
		
		Date submitTime = new Date();
		Long taskId = submitTime.getTime();
		String serialNo="USER-EXPORT-"+taskId;
		String taskName="学习项目-按用户统计-查看-下载结果数据-"+taskId;
		RequestContext requestContext = ContextHolder.get();
		Long companyId = requestContext.getCompanyId();
		Long siteId =requestContext.getSiteId();
		Long adminId=requestContext.getAccountId();
		Boolean isAdmin=requestContext.isAdmin();
		TrainingProjectGroupParam trainingGroupParam=new TrainingProjectGroupParam();
		trainingGroupParam.setCompanyId(companyId);
		trainingGroupParam.setSiteId(siteId);
		trainingGroupParam.setAdminId(adminId);
		trainingGroupParam.setIsAdmin(isAdmin);
		trainingGroupParam.setSerialNo(serialNo);
		trainingGroupParam.setTaskId(taskId);
		trainingGroupParam.setSubmitTime(submitTime);
		trainingGroupParam.setTaskName(taskName);
		trainingGroupParam.setAccountId(accountId);
		trainingGroupParam.setProjectName(projectName);
		trainingGroupParam.setStartDate(startDate);
		trainingGroupParam.setEndDate(endDate);
		statisticsTrainingClient.trainingProjectAccountGroupViewExcel(trainingGroupParam);
		return Response.ok("任务编号："+serialNo+"。任务名称："+taskName);
	}

	
	@ApiOperation(value = "按部门统计", notes = "按部门统计", response = ReportStudyTrainingProjectOrgVo.class)
    @GetMapping("/org/group")
    public Response<ReportStudyTrainingProjectOrgVo> trainingProjectOrgGroup(
    		@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate, 
    		@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate, 
    		@ApiParam(value = "部门编码或名称", required = false) @RequestParam(name = "kwd", required = false) String kwd,    
    		@ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
    		@ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo){
		
		RequestContext requestContext = ContextHolder.get();
		Long companyId = requestContext.getCompanyId();
		Long siteId =requestContext.getSiteId();
		Long adminId=requestContext.getAccountId();
		Boolean isAdmin=requestContext.isAdmin();
		TrainingProjectGroupParam trainingGroupParam=new TrainingProjectGroupParam();
		trainingGroupParam.setStartDate(startDate);
		trainingGroupParam.setEndDate(endDate);
		trainingGroupParam.setPageNo(pageNo);
		trainingGroupParam.setPageSize(pageSize);
		trainingGroupParam.setCompanyId(companyId);
		trainingGroupParam.setSiteId(siteId);
		trainingGroupParam.setAdminId(adminId);
		trainingGroupParam.setIsAdmin(isAdmin);
		trainingGroupParam.setKwd(kwd);
		
		Page<ReportStudyTrainingProjectOrgVo> page=statisticsTrainingClient.trainingProjectOrgGroup(trainingGroupParam);
		Map<String, Integer> pageMap = new HashMap<String, Integer>();
		Integer total=0;
		List<ReportStudyTrainingProjectOrgVo> list=null;
		if(page!=null) {
			total=page.getTotal();
			list=page.getRecords();
		}
		pageMap.put("pageNo", pageNo);
		pageMap.put("pageSize", pageSize);
		pageMap.put("pageTotal", total);
		return Response.ok(list, pageMap);
	}
	
	@ApiOperation(value = "按部门统计-下载结果数据", notes = "按部门统计-下载结果数据", response = ReportStudyTrainingProjectVo.class)	
    @GetMapping("/org/group/export")
    public Response<ReportStudyTrainingProjectAccountViewVo> trainingProjectAccountGroupViewExport(
    		@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate, 
    		@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate, 
    		@ApiParam(value = "部门编码或名称", required = false) @RequestParam(name = "kwd", required = false) String kwd){
		
		Date submitTime = new Date();
		Long taskId = submitTime.getTime();
		String serialNo="USER-EXPORT-"+taskId;
		String taskName="学习项目-按部门统计-下载结果数据-"+taskId;
		RequestContext requestContext = ContextHolder.get();
		Long companyId = requestContext.getCompanyId();
		Long siteId =requestContext.getSiteId();
		Long adminId=requestContext.getAccountId();
		Boolean isAdmin=requestContext.isAdmin();
		TrainingProjectGroupParam trainingGroupParam=new TrainingProjectGroupParam();
		trainingGroupParam.setCompanyId(companyId);
		trainingGroupParam.setSiteId(siteId);
		trainingGroupParam.setAdminId(adminId);
		trainingGroupParam.setIsAdmin(isAdmin);
		trainingGroupParam.setSerialNo(serialNo);
		trainingGroupParam.setTaskId(taskId);
		trainingGroupParam.setSubmitTime(submitTime);
		trainingGroupParam.setTaskName(taskName);
		trainingGroupParam.setOrgKwd(kwd);
		trainingGroupParam.setStartDate(startDate);
		trainingGroupParam.setEndDate(endDate);
		statisticsTrainingClient.trainingProjectOrgGroupExcel(trainingGroupParam);
		return Response.ok("任务编号："+serialNo+"。任务名称："+taskName);
	}
}
