package com.yizhi.application.settlement.config;

import com.yizhi.application.settlement.handler.SettlementBaseHandler;
import com.yizhi.application.settlement.vo.SettlementBaseVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * 获取不同结算台详情的handler类
 * 如果需要新增其他类型的handler；步骤如下：
 * 1.新建一个handler 继承SettlementBaseHandler接口，接口中handler方法则是真正的处理逻辑；
 * 2.再该handler类上添加注解SettlementHandlerType 并指定type的值
 * 3.新增一个vo类；继承SettlementBaseVo
 *
 */
@Component
public class SettlementHandlerContext {

    @Autowired
    ApplicationContext applicationContext;

    //存放所有策略类Bean的map
    public static Map<Integer, Class<SettlementBaseHandler>> orderStrategyBeanMap= new HashMap<>();

    public SettlementBaseHandler getOrderStrategy(Integer type){
        Class<SettlementBaseHandler> strategyClass = orderStrategyBeanMap.get(type);
        if(strategyClass==null){
            throw new IllegalArgumentException("没有对应的订单类型");
        }
        //从容器中获取对应的策略Bean
        return applicationContext.getBean(strategyClass);
    }
}
