package com.yizhi.application.wechat.utils;

import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.system.application.system.remote.AccountClient;
import com.yizhi.wechat.application.feign.WeiXinClient;
import com.yizhi.wechat.application.vo.wechat.AccountVO;
import com.yizhi.wechat.application.vo.wechat.WeChatUserVO;
import com.yizhi.wechat.application.vo.wechat.domain.PublicPlatformConfigVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
public class WechatInfoService extends AbstractDefaultTask<String, Map<String,String>> {
	
	
	private static final Logger LOGGER = LoggerFactory.getLogger(WechatInfoService.class);
	

	@Autowired
	private AccountClient accountClient;

	@Autowired
    WeiXinClient weiXinClient;

	
	

	@Override
	protected String execute(Map<String, String> map) {

        //异步修改用户信息

        PublicPlatformConfigVo publicPlatformConfig = null;
        String accessToken =null;
        try {
            publicPlatformConfig = weiXinClient.getPlatformconfig(map.get("appid"),map.get("agentId"));
            LOGGER.info("异步公众号配置："+publicPlatformConfig);
            if (publicPlatformConfig!=null){
                accessToken = weiXinClient.getChatAccessToken(publicPlatformConfig);
                LOGGER.info("异步 获取企业的accessToken："+accessToken);
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
        Boolean aBoolean = null;


        try {
            // 查询用户的信息
            WeChatUserVO weChatUserVO = weiXinClient.getWechatUser(accessToken,map.get("wechatUserId"));
            LOGGER.info("异步 获取企业的accessToken："+accessToken);
            if (weChatUserVO!=null) {
                AccountVO accountVO = weChatUserVO.getAccountVO();
                accountVO.setId(Long.valueOf(map.get("accountId")));
                com.yizhi.system.application.vo.AccountVO systemAccountVo = new com.yizhi.system.application.vo.AccountVO();
                BeanUtils.copyProperties(accountVO,systemAccountVo);
                aBoolean = accountClient.updateAccount(systemAccountVo);
            }
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
        if (aBoolean){
            LOGGER.info("异步更新信息成功");
        }
        return null;
		 
	}

}
