package com.yizhi.application.course.util;

import com.alibaba.fastjson.JSON;

import com.yizhi.core.application.exception.FileReadException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;

public class DownLoad {

    private static final Logger logger= LoggerFactory.getLogger(DownLoad.class);

    public  String  downLoadFromUrl(String urlStr,String fileName,String outputFilePath){

        File file = null;
//        FileInfo fileInfo = new FileInfo();
        try {
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            //防止屏蔽程序抓取而返回403错误
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            conn.setRequestProperty("Charsert", "UTF-8");
            conn.setRequestProperty("Accept-Charset", "UTF-8");
            //得到输入流
            InputStream inputStream = conn.getInputStream();
            //获取自己数组
            byte[] buffer = new byte[1024];
            int len = 0;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while((len = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            bos.close();

            byte[] getData = bos.toByteArray();
            //文件保存位置
            File saveDir = new File(outputFilePath);
            if(!saveDir.exists()){
                saveDir.mkdirs();
            }
            file = new File(saveDir+File.separator+fileName);
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(getData);
            if(fos!=null){
                fos.close();
            }
            if(inputStream!=null){
                inputStream.close();
            }
        } catch (Exception e) {
            logger.info("fileName={},outputFilePath={}",fileName,outputFilePath);
            logger.info("urlStr={},异常={}",urlStr,JSON.toJSONString(e));
            throw new FileReadException();
        }
        return file.getAbsolutePath();
    }
    
    
    
    /**   
     * 从输入流中获取字节数组   
     * @param inputStream   
     * @return   
     * @throws IOException   
     */    
    public static  byte[] readInputStream(InputStream inputStream) throws IOException {      
        byte[] buffer = new byte[1024];      
        int len = 0;      
        ByteArrayOutputStream bos = new ByteArrayOutputStream();      
        while((len = inputStream.read(buffer)) != -1) {      
            bos.write(buffer, 0, len);      
        }      
        bos.close();      
        return bos.toByteArray();      
    }      
    

}
