package com.yizhi.application.util;


import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yizhi.comment.application.vo.PdfVO;
import com.yizhi.core.application.event.EventWrapper;
import com.yizhi.documents.application.enums.DocumentType;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RabbitListener(queues = "pdfToPng")
public class PdfToPngListener {

    @Autowired
    private PdfPagesAsynchronizationDeal pdfPagesAsynchronizationDeal;
    
    @Autowired
    private WebWorkUtil webWorkUtil;

    @RabbitHandler
    public void processBizEvent(EventWrapper<List<PdfVO>> eventWrapper) {
        try {
        	if (CollectionUtils.isNotEmpty(eventWrapper.getData())) {
				for(PdfVO vo:eventWrapper.getData()) {
					Map<String,Object> map = new HashMap<String, Object>();
					if (webWorkUtil.fileType(vo.getOriginalFile().substring(vo.getOriginalFile().lastIndexOf(".")+1))== DocumentType.DOCUMENT.getType()) {
						map.put("pdf",vo );
						pdfPagesAsynchronizationDeal.execute(map);
					}
				}
			}
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
