package com.yizhi.application.course.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.course.application.feign.LessonClient;
import com.yizhi.course.application.vo.CourseStudentListVo;
import com.yizhi.course.application.vo.MaterialSaveVO;
import com.yizhi.course.application.vo.MaterialStateUpdateVo;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;



import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(tags = "学员端-我的做课", description = "学员端-我的做课接口")
@RestController
@RequestMapping("/api/lesson")
public class LessonStudentController {
    @Autowired
    private LessonClient lessonClient;
	
	
	@ApiOperation(value="更改作业状态")
	@PostMapping("/update/state")
	public Response<Boolean> updateState(@RequestBody MaterialStateUpdateVo materialStateUpdateVo){
		try {
			materialStateUpdateVo.setContext(ContextHolder.get());
			Boolean x=lessonClient.updateStateStudent(materialStateUpdateVo);
			if(x) {
				return Response.ok(ReturnCode.SUCCESS);
			}
			else {
				return Response.ok(ReturnCode.UPDATE_FAIL);
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
		}
	}
	
	
	
	
	@ApiOperation(value=" 我的做课列表")
	@GetMapping("/student/myLesson/list")
	public Response<CourseStudentListVo> getMyLessonList(
			@ApiParam(name="name",value="关键字")@RequestParam(name="name",required=false)String name,
			@ApiParam(name = "pageNo", value = "要跳转的页数", required = false) @RequestParam(name = "pageNo",required=false,defaultValue = "1") int pageNo,
            @ApiParam(name = "pageSize", value = "每页条数，默认：10", required = false) @RequestParam(name = "pageSize", required=false,defaultValue = "10") int pageSize){
		
		try {
			Long accountId=ContextHolder.get().getAccountId();
			Page<CourseStudentListVo> page=lessonClient.getMyLessonList(name,pageNo,pageSize,accountId);
			if(page!=null) {
				Map<String,Integer> map=new HashMap<String,Integer>();
				map.put("current", pageNo);
				map.put("size", pageSize);
				map.put("total", page.getTotal());
        	   Pair<List<CourseStudentListVo>,Map<String,Integer>> pair = new MutablePair<List<CourseStudentListVo>,Map<String,Integer>>(page.getRecords(),map);
			   return Response.ok(pair);
			}
			else {
				return Response.ok(ReturnCode.RESOURCE_NOT_FOUND);
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
		}
	}
	
	
	/**
	 * 显示单个做课
	 */
	@ApiOperation(value="显示单个做课")
	@GetMapping("/student/myLesson/show")
	public Response<CourseStudentListVo> getMyLessonShow(@ApiParam(name="id",value="id")@RequestParam(name="id",required=true)Long id){
		try {
			CourseStudentListVo courseStudentListVo=new CourseStudentListVo();
			courseStudentListVo=lessonClient.getMyLessonShow(id);
			if(courseStudentListVo!=null) {
				return Response.ok(courseStudentListVo);
			}
			else {
				return Response.ok(ReturnCode.SERVICE_UNAVAILABLE);
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
		}
	}

	
	
	/**
	 * 新建素材
	 * @param materialSaveVO
	 * @return
	 */
	@PostMapping("/student/myLesson/save")
	public Response<Long> setMyLesson(@RequestBody MaterialSaveVO materialSaveVO){
		try {
			materialSaveVO.setContext(ContextHolder.get());
			Long x=lessonClient.setMyLesson(materialSaveVO);
			System.out.println(x);
			if(x!=null) {
			
				return Response.ok(x);
			}
			else {
			
				return Response.ok(ReturnCode.SAVE_FAIL);
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());		}
	}
}
