package com.yizhi.application.project.controller;


import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.project.controller.util.CommentUtil;
import com.yizhi.application.tools.PageTools;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.feign.api.EventTrackApiClients;
import com.yizhi.training.application.constant.ProjectConstant;
import com.yizhi.training.application.feign.TpCommentClient;
import com.yizhi.training.application.feign.TpCommentReplyClient;
import com.yizhi.training.application.vo.api.TrCommentVo;
import com.yizhi.training.application.vo.domain.TpCommentVo;
import com.yizhi.training.application.vo.manage.PageCommentVo;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

/**
 * <p>
 * 培训项目 - 评论 前端控制器
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-27
 */
@Api(tags = "培训项目--评论接口")
@RestController
@RequestMapping("/api/tpComment")
public class TpCommentApiController {

    @Autowired
    TpCommentClient tpCommentClient;

    @Autowired
    TpCommentReplyClient tpCommentReplyClient;

    @Autowired
    private CommentUtil workUtil;

    @Autowired
    private EventTrackApiClients eventTrackApiClients;
    @Autowired
    private RedisCache redisCache;

    private static final Logger LOGGER = LoggerFactory.getLogger(TpCommentApiController.class);


    @PostMapping("/save")
    @ApiOperation(value = "学员端发表项目评论", notes = "返回操作是否成功")
    public Response save(HttpServletRequest request,
                         @ApiParam(value = "传入trainingProjectId，content") @RequestBody TpCommentVo tpComment
//            @ApiParam(value = "项目id",required = true)@RequestParam("trainingProjectId")Long trainingProjectId,
//            @ApiParam(value = "评论内容",required = true)@RequestParam(name = "content")String content

    ) {
        RequestContext requestContext = ContextHolder.get();

        tpComment.setUserAvatar(requestContext.getHeadPortrait());
        tpComment.setCreateById(requestContext.getAccountId());
        tpComment.setCreateByName(requestContext.getAccountName());
        tpComment.setCompanyId(requestContext.getCompanyId());
        tpComment.setSiteId(requestContext.getSiteId());
        tpComment.setOrgId(requestContext.getOrgId() == null ? 0l : requestContext.getOrgId());
        tpComment.setAuditStatus(ProjectConstant.COMMENT_AUDIT_STATUS_UP.toString());
        Boolean f = tpCommentClient.save(tpComment);

        RequestContext context = ContextHolder.get();
        // 添加发表评论埋点
        //if(request.getHeader("Cookie")!=null&&Objects.equals(redisCache.get(request.getHeader("Cookie").replace("JSESSIONID=","")),"2")){
            eventTrackApiClients.addEvent("event_tp_comment_"+tpComment.getBizType(),tpComment.getTrainingProjectId());
        //}
        if (f) {
            LOGGER.info("发表评论成功");
            return Response.ok("发表评论成功");
        } else {
            LOGGER.error("评论失败");
            return Response.fail("评论失败");
        }

    }


    @GetMapping("/comment/list")
    @ApiOperation(value = "项目查看评论列表", notes = "项目查看评论列表", response = PageCommentVo.class)
    public Response commentList(
            @ApiParam(value = "项目主键id", required = true) @RequestParam("id") Long id,
            @ApiParam(value = "关联业务类型:1活动服务;2新闻资讯；3培训测试；4培训资讯") @RequestParam(name = "bizType", required = false) Integer bizType,
            @ApiParam(name = "pageNo", value = "跳转页数,默认第一页", required = true) @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
            @ApiParam(name = "pageSize", value = "每页条数,默认20条", required = true) @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize
    ) {
        RequestContext requestContext = ContextHolder.get();
        Page<PageCommentVo> page = tpCommentClient.list(id, bizType, requestContext.getAccountId(), pageNo, pageSize,1);
        page = workUtil.fillData(page, requestContext);
        return Response.ok(page);
    }


    /**
     * PC端展现评论的列表
     *
     * @param trCommentVo
     * @return
     */
    @PostMapping("/pc/list")
    @ApiOperation(value = "PC端培训项目展现评论列表")
    Response<PageCommentVo> tpCommentList(@ApiParam(value = "trCommentVo") @RequestBody TrCommentVo trCommentVo) {
        RequestContext requestContext = ContextHolder.get();
        Page<PageCommentVo> commentVoPage = tpCommentClient.list(trCommentVo.getTrainingProjectId(), trCommentVo.getBizType(), requestContext.getAccountId(), trCommentVo.getPageNo(), trCommentVo.getPageSize(),1);
        commentVoPage = workUtil.fillData(commentVoPage, requestContext);
        Pair pair = PageTools.split(commentVoPage);
        return Response.ok(commentVoPage, (Map<String, Integer>) pair.getRight());
    }


    /**
     * PC端培训项目展现我的评论列表
     *
     * @param trCommentVo
     * @return
     */
    @PostMapping("/pc/listByMyself")
    @ApiOperation(value = "PC端培训项目展现我的评论列表")
    Response<PageCommentVo> tpCommentMyList(@ApiParam(value = "trCommentVo") @RequestBody TrCommentVo trCommentVo) {
        RequestContext requestContext = ContextHolder.get();
        if(trCommentVo.getBizType() == null) {
        	trCommentVo.setBizType(10);
        }
        Page<PageCommentVo> commentVoPage = tpCommentClient.listByMyself(trCommentVo.getTrainingProjectId(), trCommentVo.getBizType(), requestContext.getAccountId(), trCommentVo.getPageNo(), trCommentVo.getPageSize(),1);
        commentVoPage = workUtil.fillData(commentVoPage, requestContext);
        Pair pair = PageTools.split(commentVoPage);
        return Response.ok(commentVoPage, (Map<String, Integer>) pair.getRight());
    }

    /**
     * PC端发表评论
     *
     * @param tpComment
     * @return
     */
    @PostMapping("/pc/save")
    @ApiOperation(value = "PC端培训项目发表评论")
    Response saveTpComment(@ApiParam(value = "trainingProjectId、content 必传") @RequestBody TpCommentVo tpComment) {
        RequestContext requestContext = ContextHolder.get();
        tpComment.setUserAvatar(requestContext.getHeadPortrait());
        tpComment.setCreateById(requestContext.getAccountId());
        tpComment.setCreateByName(requestContext.getAccountName());
        tpComment.setCompanyId(requestContext.getCompanyId());
        tpComment.setAuditorTime(new Date());
        tpComment.setSiteId(requestContext.getSiteId());
        tpComment.setOrgId(requestContext.getOrgId() == null ? 0l : requestContext.getOrgId());
        tpComment.setAuditStatus(ProjectConstant.COMMENT_AUDIT_STATUS_UP.toString());
        if (null == tpComment.getContent()) {
            Response.fail(Constants.MSG_COMMENT_IS_NOT_NULL.getCode().toString(),
                    Constants.MSG_COMMENT_IS_NOT_NULL.getName());
        }
        Boolean flag = tpCommentClient.save(tpComment);
        if (!flag) {
            return Response.fail(Constants.MSG_COMMENT_FAIL.getCode().toString(),
                    Constants.MSG_COMMENT_FAIL.getName());
        }
        return Response.ok(Constants.MSG_COMMENT_SUCCESS.getCode().toString(), Constants.MSG_COMMENT_SUCCESS.getName());

    }


}

