package com.yizhi.application.report;

import java.util.List;

import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.statistics.application.feign.StudentReportClient;
import com.yizhi.statistics.application.vo.report.ReportDetailVO;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;


import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(tags = "学员端-平台报告相关接口")
@RestController
@RequestMapping("/api/report")
public class ReportApiController {

	@Autowired
	private StudentReportClient studentReportClient;

	private Logger logger = LoggerFactory.getLogger(ReportApiController.class);

	@GetMapping("/save")
	@ApiOperation(value = "学员端用户平台报告跑批",response = ReportDetailVO.class)
	public Response<ReportDetailVO> save() {
		studentReportClient.save(null);
		return Response.ok();
	}

	@GetMapping("/get")
	@ApiOperation(value = "学员端用户平台报告查询",response = ReportDetailVO.class)
	public Response<ReportDetailVO> get(@ApiParam(name = "reportId",value = "报告id")@RequestParam("reportId") Long reportId) {
		try {
	    	RequestContext context = ContextHolder.get();
	    	Long siteId = context.getSiteId();
	    	Long companyId = context.getCompanyId();
	    	Long accountId = context.getAccountId();
			ReportDetailVO detail = studentReportClient.get(reportId, siteId, companyId, accountId);
			return Response.ok(detail);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			logger.error("学员平台报告详情查询异常：",e);
			return Response.fail(Constants.MSG_BIZ_FAIL);
		}
	}

	@GetMapping("/list")
	@ApiOperation(value = "学员端平台报告列表",response = ReportDetailVO.class)
	public Response<List<ReportDetailVO>> list(){
		try {
			List<ReportDetailVO> list = studentReportClient.list();
			return Response.ok(list);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			logger.error("学员平台报告列表查询异常：",e);
			return Response.fail(Constants.MSG_BIZ_FAIL);
		}
	}

	@GetMapping("/view")
	@ApiOperation(value = "学员端平台报告改变查看状态")
	public Response<String> view(@ApiParam(name = "reportId",value = "报告id")@RequestParam("reportId") Long reportId) {
		try {
			Boolean view = studentReportClient.view(reportId);
				return Response.ok(view);
		} catch (Exception e) {
			logger.error("学员平台报告查看状态接口异常：",e);
			return Response.fail(Constants.MSG_BIZ_FAIL);
		}
	}
}
