package com.yizhi.application.portal.controller;

import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.site.application.feign.api.PortalBlockFeignClients;
import com.yizhi.site.application.vo.site.PortalBlockVO;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 9:34 2018/7/25
 * @Modified By
 */
@Api(tags = "门户首页列表，各个区块显示管理")
@RestController
@RequestMapping("/manage/portalBlock")
public class PortalBlockManageController {

    @Autowired
    PortalBlockFeignClients portalBlockClients;

    @ApiOperation(value = "根据终端id和区块id修改显示状态）", response = PortalBlockVO.class)
    @RequestMapping(value = "/status/change",method = RequestMethod.POST)
    public Response<PortalBlockVO> displayChange(@RequestBody PortalBlockVO portalBlockVO){
        portalBlockVO.setOptionId(ContextHolder.get().getAccountId());
        portalBlockVO.setOptionName(ContextHolder.get().getAccountName());
        return Response.ok(portalBlockClients.displayChange(portalBlockVO));
    }

    @ApiOperation(value = "根据终端id和区块id获取区块状态信息，通过该信息做查看和修改显示状态", response = PortalBlockVO.class)
    @RequestMapping(value = "/terminalId/get",method = RequestMethod.GET)
    public Response<PortalBlockVO> getByTerminalId(
            @ApiParam(name = "terminalId", value = "终端id" ,required = true)
            @RequestParam(value = "terminalId") Long terminalId,

            @ApiParam(name = "blockType",
                    value = "门户列表区块的类型 1：底部菜单区块；2：菜单栏区块；3：公告栏区块" ,
                    required = true)
            @RequestParam(value = "blockType") Integer blockType){

        return Response.ok(portalBlockClients.getByTerminalId(terminalId,blockType
                ,ContextHolder.get().getAccountId(),ContextHolder.get().getAccountName()));
    }
}
