package com.yizhi.application.search.controller;

import java.util.List;

import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.site.application.feign.api.PortalApiFeignClients;
import com.yizhi.site.application.vo.domain.TrSearchRecordeVo;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;


import io.swagger.annotations.Api;

@Api(tags = "学员端搜索记录")
@RestController
@RequestMapping("/api/search/recorde")
public class SearchController {
	
	
	@Autowired
	private PortalApiFeignClients portalApiFeignClients;
	
	@GetMapping("/list")
	public Response<List> getRecordeList(@RequestParam("type")Integer type){
		try {
			Long accountId= ContextHolder.get().getAccountId();
			Long companyId=ContextHolder.get().getCompanyId();
			Long siteId=ContextHolder.get().getSiteId();
			Long orgId=ContextHolder.get().getOrgId();
			TrSearchRecordeVo tr=new TrSearchRecordeVo();
			tr.setAccountId(accountId);
			tr.setCompanyId(companyId);
			tr.setSiteId(siteId);
			tr.setOrgId(orgId);
			tr.setType(type);
			return Response.ok(portalApiFeignClients.getSearchRecorde(tr));
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
		}
	}
	
	
	
	@GetMapping("/save")
	public Response<Boolean> saveContent(@RequestParam("content")String content,@RequestParam("type")Integer type){
		try {
			Long accountId=ContextHolder.get().getAccountId();
			Long companyId=ContextHolder.get().getCompanyId();
			Long siteId=ContextHolder.get().getSiteId();
			Long orgId=ContextHolder.get().getOrgId();
			TrSearchRecordeVo tr=new TrSearchRecordeVo();
			tr.setAccountId(accountId);
			tr.setCompanyId(companyId);
			tr.setSiteId(siteId);
			tr.setOrgId(orgId);
			tr.setType(type);
			//去除前后空格
			content=content.trim();
			if(content.length()>50) {
				content=content.substring(0, 50);
			}
			if(content.length()==0) {
				return Response.ok(true);
			}
			else {
				tr.setContent(content);
				return Response.ok(portalApiFeignClients.saveSearchRecorde(tr));
			}
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
		}
	}
	
	
	
	@GetMapping("/delete")
	public Response<List> deleteRecordeList(@RequestParam("type")Integer type){
		try {
			Long accountId=ContextHolder.get().getAccountId();
			Long companyId=ContextHolder.get().getCompanyId();
			Long siteId=ContextHolder.get().getSiteId();
			Long orgId=ContextHolder.get().getOrgId();
			TrSearchRecordeVo tr=new TrSearchRecordeVo();
			tr.setAccountId(accountId);
			tr.setCompanyId(companyId);
			tr.setSiteId(siteId);
			tr.setOrgId(orgId);
			tr.setType(type);
			return Response.ok(portalApiFeignClients.deleteSearchRecorde(tr));
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
		}
	}
	
	
	

}
