package com.yizhi.application.settlement.config;

import com.yizhi.application.settlement.annotation.SettlementHandlerType;
import com.yizhi.application.settlement.handler.SettlementBaseHandler;
import com.yizhi.application.settlement.vo.SettlementBaseVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 获取添加了自定义注解SettlementHandlerType的类；并将其对应注入到map中
 */
@Component
public class SettlementHandlerProcessor implements ApplicationContextAware {

    private static final Logger LOGGER = LoggerFactory.getLogger(SettlementHandlerProcessor.class);
    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {

        //获取所有策略注解的Bean
        Map<String, Object> orderStrategyMap = applicationContext.getBeansWithAnnotation(SettlementHandlerType.class);
        orderStrategyMap.forEach((k,v)->{
            //获取策略实现类
            Class<SettlementBaseHandler> orderStrategyClass = (Class<SettlementBaseHandler>) v.getClass();
            //获取策略实现类的注解值。
            int type = orderStrategyClass.getAnnotation(SettlementHandlerType.class).type();
            //将class加入SettlementHandlerContext的map中,type作为key
            LOGGER.info("---开始获取添加了自定义注解SettlementHandlerType的类----");
            SettlementHandlerContext.orderStrategyBeanMap.put(type,orderStrategyClass);
        });
        LOGGER.info("---获取添加了自定义注解SettlementHandlerType的类；orderStrategyBeanMap.size() = {}----",orderStrategyMap.size());
    }
}
