package com.yizhi.application.customProject.contoller;


import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.custom.api.feign.CodePackageManageClient;
import com.yizhi.custom.api.param.ExperiencePoolParam;
import com.yizhi.custom.api.vo.domain.CodePackageManageVo;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 代码包管理端
 *
 * @author ding
 * @date 2018/11/5
 */
@Api(tags = "代码包管理接口", description = "代码包管理接口")
@RestController
@RequestMapping("/manage/codePackage")
public class CodePackageManageController {

    private static final Logger LOGGER = LoggerFactory.getLogger(CodePackageManageController.class);

    @Autowired
    private CodePackageManageClient packageManageClient;

    @ApiOperation(value = "显示代码包列表", notes = "显示代码包列表", response = CodePackageManageVo.class)
    @GetMapping("/list")
    public Response<CodePackageManageVo> getExperiencePoolList(@ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false) Integer pageNo,

                                                             @ApiParam(value = "每页条数", required = false) @RequestParam(name = "pageSize", required = false) Integer pageSize) {
        Page<CodePackageManageVo> page = null;
        try {
            RequestContext res = ContextHolder.get();
            Long companyId = res.getCompanyId();
            Long siteId = res.getSiteId();
            List<Long> orgIds = null;
            ExperiencePoolParam experiencePoolParam = new ExperiencePoolParam();
            experiencePoolParam.setCompanyId(companyId);
            experiencePoolParam.setSiteId(siteId);
            experiencePoolParam.setPageNo(pageNo);
            experiencePoolParam.setPageSize(pageSize);
            if (!res.isAdmin() && CollectionUtils.isNotEmpty(res.getOrgIds())) {
                orgIds = res.getOrgIds();
                experiencePoolParam.setOrgIds(orgIds);
            }
            page = packageManageClient.getCodePackageManageList(experiencePoolParam);

            return Response.ok(page);

        } catch (Exception e) {
            LOGGER.error("显示经验池列表失败", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "修改改代码包单个查看", notes = "修改改代码包单个查看", response = CodePackageManageVo.class)
    @GetMapping("/view")
    public Response<CodePackageManageVo> viewCodePackage(@ApiParam(value = "代码包ID", required = false) @RequestParam(name = "CodePackageId", required = false) Long CodePackageId) {
        CodePackageManageVo codePackageManage = null;
        try {
            codePackageManage = packageManageClient.viewCodePackageManage(CodePackageId);

            return Response.ok(codePackageManage);

        } catch (Exception e) {
            LOGGER.error("修改改代码包单个查看失败", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "代码包新增(修改)", notes = "代码包新增(修改)", response = CodePackageManageVo.class)
    @GetMapping("/insert")
    public Response<CodePackageManageVo> insertCodePackage(@RequestParam(name = "codePackageId", required = false) Long codePackageId,
                                                         @RequestParam(name = "codePackageName", required = false) String codePackageName,
                                                         @ApiParam(value = "url", required = true) @RequestParam(name = "url", required = true) String url) {
        CodePackageManageVo codePackageManage = null;
        try {
            codePackageManage = packageManageClient.insertCodePackage(codePackageId, codePackageName, url);

            return Response.ok(codePackageManage);

        } catch (Exception e) {
            LOGGER.error("", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "复制访问路径", notes = "复制访问路径")
    @GetMapping("/getUrl")
    public Response<String> getCodePackageUrl(@ApiParam(value = "代码包ID", required = true) @RequestParam(name = "CodePackageId", required = true) Long CodePackageId) {
        String url = null;
        try {
            url = packageManageClient.getCodePackageUrl(CodePackageId);

            return Response.ok(url);

        } catch (Exception e) {
            LOGGER.error("复制访问路径失败", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "导出二维码", notes = "导出二维码")
    @GetMapping("/getQRCode")
    public Response<String> getQRCode(@ApiParam(value = "代码包ID", required = true) @RequestParam(name = "CodePackageId", required = true) Long CodePackageId,
                                      @ApiParam(value = "url", required = true) @RequestParam(name = "url", required = true) String url) {
        return null;
    }

    @ApiOperation(value = "删除代码包", notes = "删除代码包")
    @GetMapping("/delete")
    public Response<String> deleteCodePackage(@ApiParam(value = "代码包ID", required = true) @RequestParam(name = "CodePackageId", required = true) Long CodePackageId) {
        boolean isOk = false;
        try {
            isOk = packageManageClient.deleteCodePackage(CodePackageId);
            if (isOk) {
                return Response.ok();
            } else {
                return Response.fail(ReturnCode.DELETE_FAIL.getCode(),ReturnCode.DELETE_FAIL.getMsg());
            }
        } catch (Exception e) {
            LOGGER.error("删除代码包失败", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }


}