package com.yizhi.application.point.controller;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.course.application.vo.RangeImportParamVo;
import com.yizhi.point.application.feign.PointFeignClients;
import com.yizhi.point.application.feign.PointManageFeignClients;
import com.yizhi.point.application.vo.PointDetailsVO;
import com.yizhi.point.application.vo.domain.PointVo;
import com.yizhi.statistics.application.feign.StatisticsPointClient;
import com.yizhi.statistics.application.request.point.StatisticsPointDetailQO;
import com.yizhi.statistics.application.request.point.StatisticsPointQO;
import com.yizhi.statistics.application.vo.point.StatisticsPointDetailVO;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

/**
 * 我的积分
 *
 * @author mei
 * @Date: 2018/3/17 20:30
 */

@Api(tags = "积分策略")
@RestController
@RequestMapping("/manage/point")
public class PointController {

    private static final Logger LOG = LoggerFactory.getLogger(PointController.class);

    @Autowired
    PointFeignClients pointFeignClients;

    @Autowired
    PointManageFeignClients pointManageFeignClients;

    @Autowired
    ExternalPointImport externalPointImport;

    @Autowired
    StatisticsPointClient statisticsPointClient;


    @ApiOperation(value = "积分策略列表", notes = "积分策略列表", response = PointVo.class)
    @GetMapping("/strategy/view")
    public Response<PointVo> pointList() {
        RequestContext requestContext = ContextHolder.get();
        if (null == requestContext) {
            Response.fail();
        }

        Long companyId = requestContext.getCompanyId();
        Long siteId = requestContext.getSiteId();
        return Response.ok(pointFeignClients.pointList(companyId, siteId));
    }

    @ApiOperation(value = "积分策略修改", notes = "积分策略修改")
    @PostMapping("/strategy/update")
    public Response<Boolean> pointList(@RequestBody PointVo point) {
        RequestContext requestContext = ContextHolder.get();
        if (null == requestContext) {
            Response.fail();
        }

        Long companyId = requestContext.getCompanyId();
        Long siteId = requestContext.getSiteId();
        Long orgId = requestContext.getOrgId();
        Long accountId = requestContext.getAccountId();
        String accountName = requestContext.getAccountName();
        point.setSiteId(siteId);
        point.setCompanyId(companyId);
        point.setUpdateById(accountId);
        point.setOrgId(orgId);
        point.setUpdateByName(accountName);
        boolean isOk = pointFeignClients.updateList(point);
        return Response.ok(isOk);
    }

    @ApiOperation(value = "积分流水明细", notes = "积分流水明细", response = PointDetailsVO.class)
    @GetMapping("/details/list")
    Response<Object> getManagePointDetails(@ApiParam(value = "类型", required = false) @RequestParam(name = "learnType", required = false) String learnType,
                                           @ApiParam(value = "用户", required = false) @RequestParam(name = "accountName", required = false) String accountName,
                                           @ApiParam(value = "查询开始日期，时间戳", required = false) @RequestParam(name = "startTime", required = false) Long startTime,
                                           @ApiParam(value = "查询结束日期，时间戳", required = false) @RequestParam(name = "endTime", required = false) Long endTime,
                                           @ApiParam(value = "页码", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
                                           @ApiParam(value = "每页显示页数", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize) {
        RequestContext requestContext = ContextHolder.get();
        if (null == requestContext) {
            Response.fail();
        }
        Long companyId = requestContext.getCompanyId();
        Long siteId = requestContext.getSiteId();
        try {
            Page<PointDetailsVO> page = pointManageFeignClients.getManagePointDetails(learnType, accountName,
                    startTime, endTime, pageNo, pageSize, companyId, siteId);
            return Response.ok(page);
        } catch (Exception e) {
            LOG.error("服务出错。", e);
            return Response.fail();
        }
    }

    @ApiOperation(value = "积分导入", notes = "积分导入")
    @PostMapping("/import")
    public Response<String> importPoolActivityExperiences(@RequestBody RangeImportParamVo importParam) {
        Map<String, Object> map = new HashMap<>();
        RequestContext res = ContextHolder.get();
        Long taskId = System.currentTimeMillis();
        String serialNo = "POINT-IMPORT-" + taskId.toString();
        String taskName = "积分导入-" + taskId.toString();
        String url = importParam.getOssUrl();
        map.put("taskId", taskId);
        map.put("taskName", taskName);
        map.put("serialNo", serialNo);
        map.put("res", res);
        map.put("url", url);
        externalPointImport.execute(map, true);
        return Response.ok("导入成功: 编号" + serialNo);
    }

    @PostMapping("/detail/get")
    @ApiOperation("获取用户积分明细")
    public Response<Object> getStatisticsPoint(@RequestBody StatisticsPointDetailQO qo) {
        Page<StatisticsPointDetailVO> page = statisticsPointClient.getStatisticsPoint(qo);
        Map<String, Integer> pageMap = new HashMap<String, Integer>();
        pageMap.put("pageNo", qo.getPageNo());
        pageMap.put("pageSize", qo.getPageSize());
        pageMap.put("pageTotal", page.getTotal());
        return Response.ok(page.getRecords(), pageMap);
    }

    @PostMapping("/detail/export")
    @ApiOperation("导出用户积分明细")
    public Response<String> exportStatisticsPoint(@RequestBody StatisticsPointDetailQO qo) {
        return Response.ok("导出积分个人明细成功: 编号" + statisticsPointClient.exportStatisticsPoint(qo));
    }


    @PostMapping("/export")
    @ApiOperation("导出全部用户积分明细")
    public Response<String> exportAllStatisticsPoint(@RequestBody StatisticsPointQO qo) {
        return Response.ok("导出全部用户积分明细: 编号" + statisticsPointClient.exportAllStatisticsPoint(qo));
    }
}
