package com.yizhi.application.portal.controller;

import com.yizhi.site.application.feign.PortalManageFeignClients;
import com.yizhi.site.application.vo.domain.SiteDicVo;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 站点管理
 *
 * @author lly
 * @Date: 2018/3/17 20:30
 */

@Api(tags = "门户字典管理")
@RestController
@RequestMapping("/manage/site")
public class SiteManageController {
    @Autowired
    PortalManageFeignClients portalManageFeignClients;

    @GetMapping("/dic")
    public Response getSiteDic(@ApiParam(name = "code", value = "移动端code：mb;pc端code：pc;") @RequestParam(name = "code") String code) {
        return Response.ok(portalManageFeignClients.list(code));

    }

    /**
    * 修改字典
    *
    * @param siteDic
    * @return
    */
    @PostMapping("/dic/update")
    public Response updateById(@RequestBody SiteDicVo siteDic) {

        try {
            siteDic = portalManageFeignClients.updateById(siteDic);
        } catch (Exception e) {
            return Response.fail();
        }
        return Response.ok(siteDic);
    }
}
