package com.yizhi.application.report.album;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.statistics.application.album.vo.*;
import com.yizhi.statistics.application.feign.ReportAlbumClient;
import com.yizhi.util.application.domain.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.plugins.Page;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(tags = "报表统计-专辑", description = "报表统计-专辑")
@RestController
@RequestMapping("/manage/report/album")
public class StatisticsAlbumController {

	private static final Logger logger = LoggerFactory.getLogger(StatisticsAlbumController.class);
	
	@Autowired
	private ReportAlbumClient reportAlbumClient;
	/**
	 * 图形报表
	 * @param startDate
	 * @param endDate
	 * @return
	 */
		@ApiOperation(value = "图表数据统计", notes = "图表数据统计", response = ReportStudyAlbumChartsVo.class)
		@GetMapping("/chart/group")
		public Response<ReportStudyAlbumChartsVo> chartGroup(
				@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate,
				@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate) {
			List<ReportStudyAlbumChartsVo> list = new ArrayList<ReportStudyAlbumChartsVo>();
			RequestContext requestContext = ContextHolder.get();
			Long companyId = requestContext.getCompanyId();
			Long siteId = requestContext.getSiteId();
			Long adminId=requestContext.getAccountId();
			Boolean isAdmin=requestContext.isAdmin();
			AlbumGroupParam param = new AlbumGroupParam();
			param.setCompanyId(companyId);
			param.setSiteId(siteId);
			param.setAdminId(adminId);
			param.setIsAdmin(isAdmin);
			param.setStartDate(startDate);
			param.setEndDate(endDate);
			logger.info(param.toStringVO());
			list = reportAlbumClient.chartGroup(param);
			return Response.ok(list);
		}

		/**
		 * 按照专辑统计
		 * @param startDate
		 * @param endDate
		 * @param kwd
		 * @param pageSize
		 * @param pageNo
		 * @return
		 */
		@ApiOperation(value = "按专辑统计", notes = "按专辑统计", response = ReportStudyAlbumVo.class)
		@GetMapping("/group")
		public Response<ReportStudyAlbumVo> albumGroup(
				@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate,
				@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate,
				@ApiParam(value = "专辑关键字", required = false) @RequestParam(name = "kwd", required = false) String kwd,
				@ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
				@ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo) {

			RequestContext requestContext = ContextHolder.get();
			Long companyId = requestContext.getCompanyId();
			Long siteId =requestContext.getSiteId();
			Long adminId=requestContext.getAccountId();
			Boolean isAdmin=requestContext.isAdmin();
			AlbumGroupParam param=new AlbumGroupParam();
			param.setStartDate(startDate);
			param.setEndDate(endDate);
			param.setKwd(kwd);
			param.setPageNo(pageNo);
			param.setPageSize(pageSize);
			param.setCompanyId(companyId);
			param.setSiteId(siteId);
			param.setAdminId(adminId);
			param.setIsAdmin(isAdmin);
			logger.info(param.toStringVO());
			Page<ReportStudyAlbumVo> page = reportAlbumClient.albumGroup(param);
			Map<String, Integer> pageMap = new HashMap<String, Integer>();
			Integer total=0;
			List<ReportStudyAlbumVo> list=null;
			if(page!=null) {
				total=page.getTotal();
				list=page.getRecords();
			}
			pageMap.put("pageNo", pageNo);
			pageMap.put("pageSize", pageSize);
			pageMap.put("pageTotal", total);
			return Response.ok(list, pageMap);
		}

		/**
		 * 按照专辑统计下载
		 * @param request
		 * @param startDate
		 * @param endDate
		 * @param kwd
		 * @return
		 */
		@ApiOperation(value = "按专辑统计导出结果数据Excel", notes = "按照专辑统计导出结果数据Excel")
		@GetMapping("/group/export")
		public Response<String> albumGroupExport(HttpServletRequest request,
				@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate,
				@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate,
				@ApiParam(value = "专辑关键字", required = false) @RequestParam(name = "kwd", required = false) String kwd) {

			Date submitTime = new Date();
			Long taskId = submitTime.getTime();
			String serialNo="USER-EXPORT-"+taskId;
			String taskName="专辑-按专辑统计-下载结果数据-"+taskId;
			RequestContext requestContext = ContextHolder.get();
			Long companyId = requestContext.getCompanyId();
			Long siteId =requestContext.getSiteId();
			Long adminId=requestContext.getAccountId();
			Boolean isAdmin=requestContext.isAdmin();
			AlbumGroupParam param=new AlbumGroupParam();
			param.setStartDate(startDate);
			param.setEndDate(endDate);
			param.setKwd(kwd);
			param.setCompanyId(companyId);
			param.setSiteId(siteId);
			param.setAdminId(adminId);
			param.setIsAdmin(isAdmin);
			param.setSerialNo(serialNo);
			param.setTaskId(taskId);
			param.setSubmitTime(submitTime);
			param.setTaskName(taskName);
			logger.info(param.toStringVO());
			reportAlbumClient.albumGroupExport(param);
			return Response.ok("任务编号："+serialNo+"。任务名称："+taskName);
		}

		
		/**
		 * 按照专辑统计
		 */
		@ApiOperation(value = "按专辑统计", notes = "按专辑统计", response = ReportStudyAlbumViewVo2.class)
		@GetMapping("/group/view")
		public Response<ReportStudyAlbumVo> albumGroupView(
				@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate,
				@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate,
				@ApiParam(value = "专辑id", required = true) @RequestParam(name = "albumId", required = true) Long albumId) {

			RequestContext requestContext = ContextHolder.get();
			Long companyId = requestContext.getCompanyId();
			Long siteId =requestContext.getSiteId();
			Long adminId=requestContext.getAccountId();
			Boolean isAdmin=requestContext.isAdmin();
			AlbumGroupParam param=new AlbumGroupParam();
			param.setStartDate(startDate);
			param.setEndDate(endDate);
			param.setAlbumId(albumId);
			param.setCompanyId(companyId);
			param.setSiteId(siteId);
			param.setAdminId(adminId);
			param.setIsAdmin(isAdmin);
			logger.info(param.toStringVO());
			List<ReportStudyAlbumViewVo2> list = reportAlbumClient.albumGroupView(param);
			return Response.ok(list);
		}
		
		/**
		 * 按照专辑统计下载
		 */
		@ApiOperation(value = "按用户统计导出专辑学习结果Excel", notes = "按照用户统计导出专辑学习结果Excel")
		@GetMapping("/group/view/export1")
		public Response<String> albumGroupViewExport1(HttpServletRequest request,
				@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate,
				@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate,
				@ApiParam(value = "专辑id", required = true) @RequestParam(name = "albumId", required = true) Long albumId) {

			Date submitTime = new Date();
			Long taskId = submitTime.getTime();
			String serialNo="USER-EXPORT-"+taskId;
			String taskName="专辑-按专辑统计-查看-下载专辑学习结果-"+taskId;
			RequestContext requestContext = ContextHolder.get();
			Long companyId = requestContext.getCompanyId();
			Long siteId =requestContext.getSiteId();
			Long adminId=requestContext.getAccountId();
			Boolean isAdmin=requestContext.isAdmin();
			AlbumGroupParam param=new AlbumGroupParam();
			param.setStartDate(startDate);
			param.setEndDate(endDate);
			param.setAlbumId(albumId);
			param.setCompanyId(companyId);
			param.setSiteId(siteId);
			param.setAdminId(adminId);
			param.setIsAdmin(isAdmin);
			param.setSerialNo(serialNo);
			param.setTaskId(taskId);
			param.setSubmitTime(submitTime);
			param.setTaskName(taskName);
			logger.info(param.toStringVO());
			reportAlbumClient.albumGroupViewExport1(param);
			return Response.ok("任务编号："+serialNo+"。任务名称："+taskName);
		}
		
		/**
		 * 按照专辑统计下载
		 */
		@ApiOperation(value = "按用户统计导出课程完成情况Excel", notes = "按用户统计导出课程完成情况Excel")
		@GetMapping("/group/view/export2")
		public Response<String> albumGroupViewExport2(HttpServletRequest request,
				@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate,
				@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate,
				@ApiParam(value = "专辑id", required = true) @RequestParam(name = "albumId", required = true) Long albumId) {

			Date submitTime = new Date();
			Long taskId = submitTime.getTime();
			String serialNo="USER-EXPORT-"+taskId;
			String taskName="专辑-按专辑统计-下载课程完成情况-"+taskId;
			RequestContext requestContext = ContextHolder.get();
			Long companyId = requestContext.getCompanyId();
			Long siteId =requestContext.getSiteId();
			Long adminId=requestContext.getAccountId();
			Boolean isAdmin=requestContext.isAdmin();
			AlbumGroupParam param=new AlbumGroupParam();
			param.setStartDate(startDate);
			param.setEndDate(endDate);
			param.setAlbumId(albumId);
			param.setCompanyId(companyId);
			param.setSiteId(siteId);
			param.setAdminId(adminId);
			param.setIsAdmin(isAdmin);
			param.setSerialNo(serialNo);
			param.setTaskId(taskId);
			param.setSubmitTime(submitTime);
			param.setTaskName(taskName);
			logger.info(param.toStringVO());
			reportAlbumClient.albumGroupViewExport2(param);
			return Response.ok("任务编号："+serialNo+"。任务名称："+taskName);
		}
		
		/**
		 * 按照专辑统计下载
		 */
		@ApiOperation(value = "按用户统计导出学员学习明细Excel", notes = "按用户统计导出学员学习明细Excel")
		@GetMapping("/group/view/export3")
		public Response<String> albumGroupViewExport3(HttpServletRequest request,
				@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate,
				@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate,
				@ApiParam(value = "专辑id", required = true) @RequestParam(name = "albumId", required = true) Long albumId) {

			Date submitTime = new Date();
			Long taskId = submitTime.getTime();
			String serialNo="USER-EXPORT-"+taskId;
			String taskName="专辑-按专辑统计-下载学员学习明细-"+taskId;
			RequestContext requestContext = ContextHolder.get();
			Long companyId = requestContext.getCompanyId();
			Long siteId =requestContext.getSiteId();
			Long adminId=requestContext.getAccountId();
			Boolean isAdmin=requestContext.isAdmin();
			AlbumGroupParam param=new AlbumGroupParam();
			param.setStartDate(startDate);
			param.setEndDate(endDate);
			param.setAlbumId(albumId);
			param.setCompanyId(companyId);
			param.setSiteId(siteId);
			param.setAdminId(adminId);
			param.setIsAdmin(isAdmin);
			param.setSerialNo(serialNo);
			param.setTaskId(taskId);
			param.setSubmitTime(submitTime);
			param.setTaskName(taskName);
			logger.info(param.toStringVO());
			reportAlbumClient.albumGroupViewExport3(param);
			return Response.ok("任务编号："+serialNo+"。任务名称："+taskName);
		}
		/**
		 * 按照用户统计
		 * @param startDate
		 * @param endDate
		 * @param orgKwd
		 * @param accountKwd
		 * @param pageSize
		 * @param pageNo
		 * @return
		 */
		@ApiOperation(value = "按用户统计", notes = "按用户统计", response = ReportStudyAlbumAccountVo.class)
		@GetMapping("/account/group")
		public Response<ReportStudyAlbumAccountVo> courseAccountGroup(
				@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate,
				@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate,
				@ApiParam(value = "部门编码或名称", required = false) @RequestParam(name = "orgKwd", required = false) String orgKwd,
				@ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountKwd", required = false) String accountKwd,
				@ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
				@ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo) {
			RequestContext requestContext = ContextHolder.get();
			Long companyId = requestContext.getCompanyId();
			Long siteId =requestContext.getSiteId();
			Long adminId=requestContext.getAccountId();
			Boolean isAdmin=requestContext.isAdmin();
			AlbumGroupAccountParam param=new AlbumGroupAccountParam();
			param.setOrgKwd(orgKwd);
			param.setAccountKwd(accountKwd);
			param.setPageNo(pageNo);
			param.setPageSize(pageSize);
			param.setStartDate(startDate);
			param.setEndDate(endDate);
			param.setCompanyId(companyId);
			param.setSiteId(siteId);
			param.setAdminId(adminId);
			param.setIsAdmin(isAdmin);
			logger.info(param.toStringVO());
		   Page<ReportStudyAlbumAccountVo>	page = reportAlbumClient.albumAccountGroup(param);
			Map<String, Integer> pageMap = new HashMap<String, Integer>();
			Integer total=0;
			List<ReportStudyAlbumAccountVo> list=null;
			if(page!=null) {
				total=page.getTotal();
				list=page.getRecords();
			}

			pageMap.put("pageNo", pageNo);
			pageMap.put("pageSize", pageSize);
			pageMap.put("pageTotal", total);
			return Response.ok(list, pageMap);
		}

		/**
		 * 按照用户统计导出
		 * @param request
		 * @param startDate
		 * @param endDate
		 * @param orgKwd
		 * @param accountKwd
		 * @return
		 */
		@ApiOperation(value = "按用户统计导出Excel----下载学习统计数据", notes = "按用户统计导出Excel")
		@GetMapping("/account/group/export")
		public Response<String> courseAccountGroupExportExcel(HttpServletRequest request,
				@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate,
				@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate,
				@ApiParam(value = "部门编码或名称", required = false) @RequestParam(name = "orgKwd", required = false) String orgKwd,
				@ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountKwd", required = false) String accountKwd) {

			Date submitTime = new Date();
			Long taskId = submitTime.getTime();
			String serialNo="USER-EXPORT-"+taskId;
			String taskName="专辑-按用户统计-下载结果数据-"+taskId;
			RequestContext requestContext = ContextHolder.get();
			Long companyId = requestContext.getCompanyId();
			Long siteId =requestContext.getSiteId();
			Long adminId=requestContext.getAccountId();
			Boolean isAdmin=requestContext.isAdmin();
			AlbumGroupAccountParam param=new AlbumGroupAccountParam();
			param.setOrgKwd(orgKwd);
			param.setAccountKwd(accountKwd);
			param.setStartDate(startDate);
			param.setEndDate(endDate);
			param.setCompanyId(companyId);
			param.setSiteId(siteId);
			param.setAdminId(adminId);
			param.setIsAdmin(isAdmin);
			param.setSerialNo(serialNo);
			param.setTaskId(taskId);
			param.setSubmitTime(submitTime);
			param.setTaskName(taskName);
			logger.info(param.toStringVO());
			reportAlbumClient.albumAccountGroupExport(param);
			return Response.ok("任务编号："+serialNo+"。任务名称："+taskName);
		}

		/**
		 *  按照用户统计详情
		 * @param startDate
		 * @param endDate
		 * @param accountId
		 * @param kwd
		 * @param pageSize
		 * @param pageNo
		 * @return
		 */
		@ApiOperation(value = "按用户统计详情", notes = "按用户统计详情", response = ReportStudyAlbumAccountViewVo.class)
		@GetMapping("/account/group/view")
		public Response<ReportStudyAlbumAccountViewVo> courseAccountGroupView(
				@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate,
				@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate,
				@ApiParam(value = "用户Id", required = true) @RequestParam(name = "accountId", required = true) Long accountId,
				@ApiParam(value = "专辑关键字", required = false) @RequestParam(name = "kwd", required = false) String kwd,
				@ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
				@ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo) {

			RequestContext requestContext = ContextHolder.get();
			Long companyId = requestContext.getCompanyId();
			Long siteId =requestContext.getSiteId();
			Long adminId=requestContext.getAccountId();
			Boolean isAdmin=requestContext.isAdmin();
			AlbumGroupAccountParam param=new AlbumGroupAccountParam();
			param.setAccountId(accountId);
			param.setIsAdmin(isAdmin);
			param.setAdminId(adminId);
			param.setAlbumKwd(kwd);
			param.setStartDate(startDate);
			param.setEndDate(endDate);
			param.setCompanyId(companyId);
			param.setSiteId(siteId);
			param.setPageNo(pageNo);
			param.setPageSize(pageSize);
			logger.info(param.toStringVO());
			Page<ReportStudyAlbumAccountViewVo> page=reportAlbumClient.albumAccountGroupView(param);

			Map<String, Integer> pageMap = new HashMap<String, Integer>();
			Integer total=0;
			List<ReportStudyAlbumAccountViewVo> list=null;
			if(page!=null) {
				total=page.getTotal();
				list=page.getRecords();
			}

			pageMap.put("pageNo", pageNo);
			pageMap.put("pageSize", pageSize);
			pageMap.put("pageTotal", total);
			return Response.ok(list, pageMap);
		}
	
		/**
		 * 按照用户统计导出
		 * @param request
		 * @param startDate
		 * @param endDate
		 * @param orgKwd
		 * @param accountKwd
		 * @return
		 */
		@ApiOperation(value = "按用户统计导出Excel----下载专辑学习结果", notes = "按用户统计导出学习结果Excel")
		@GetMapping("/account/group/view/export")
		public Response<String> albumAccountGroupViewExport(HttpServletRequest request,
				@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate,
				@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate,
				@ApiParam(value = "部门编码或名称", required = false) @RequestParam(name = "orgKwd", required = false) String orgKwd,
				@ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountKwd", required = false) String accountKwd) {

			Date submitTime = new Date();
			Long taskId = submitTime.getTime();
			String serialNo="USER-EXPORT-"+taskId;
			String taskName="专辑-按用户统计-下载专辑学习结果-"+taskId;
			RequestContext requestContext = ContextHolder.get();
			Long companyId = requestContext.getCompanyId();
			Long siteId =requestContext.getSiteId();
			Long adminId=requestContext.getAccountId();
			Boolean isAdmin=requestContext.isAdmin();
			AlbumGroupAccountParam param=new AlbumGroupAccountParam();
			param.setOrgKwd(orgKwd);
			param.setAccountKwd(accountKwd);
			param.setStartDate(startDate);
			param.setEndDate(endDate);
			param.setCompanyId(companyId);
			param.setSiteId(siteId);
			param.setAdminId(adminId);
			param.setIsAdmin(isAdmin);
			param.setSerialNo(serialNo);
			param.setTaskId(taskId);
			param.setSubmitTime(submitTime);
			param.setTaskName(taskName);
			logger.info(param.toStringVO());
			reportAlbumClient.albumAccountGroupViewExport(param);
			return Response.ok("任务编号："+serialNo+"。任务名称："+taskName);
		}

}
