package com.yizhi.application.forum.controller;


import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.accountUtil.QueryAccountUtil;
import com.yizhi.forum.application.feign.PostsForbiddenAccountClient;
import com.yizhi.forum.application.vo.domain.PostsForbiddenAccountVo;
import com.yizhi.system.application.vo.AccountVO;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Api(tags = "学员端-帖子-禁言管理")
@RestController
@RequestMapping("/student/postsForbiddenAccount")
public class StudentPostsForbiddenAccountController {

    private static final Logger LOG = LoggerFactory.getLogger(StudentPostsForbiddenAccountController.class);

    @Autowired
    private PostsForbiddenAccountClient postsForbiddenAccountClient;
    @Autowired
    private QueryAccountUtil queryAccount;

    /**
     * 添加禁言名单
     * <p>
     * forbiddenAccount
     *
     * @return
     */
    @PostMapping("/save")
    @ApiOperation(value = "添加禁言名单")
    public Response<Object> save(@ApiParam("帖子id必填 用户id必填 ") @RequestBody PostsForbiddenAccountVo forbiddenAccount
    ) {
        postsForbiddenAccountClient.save(forbiddenAccount);
        return Response.ok("添加成功！");
    }

    @GetMapping("/getPage")
    @ApiOperation(value = "获取禁言名单", response = PostsForbiddenAccountVo.class)
    public Response<Object> getPage(@ApiParam("帖子id必填 ") @RequestParam("postsId") Long postsId,
                                    @ApiParam("当前页码") @RequestParam(value = "pageNo", defaultValue = "1") Integer pageNo,
                                    @ApiParam("页内条数") @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize) {

        Page<PostsForbiddenAccountVo> page = postsForbiddenAccountClient.getPage(postsId, pageNo, pageSize);
        List<PostsForbiddenAccountVo> records = page.getRecords();

        if (!CollectionUtils.isEmpty(records)) {
            List<Long> accountIds = new ArrayList<>(records.size());
            records.forEach(a -> {
                accountIds.add(a.getAccountId());
            });
            Map<Long, AccountVO> accountVOMap = queryAccount.queryAccountByIds(accountIds);
            if (accountVOMap != null) {
                records.forEach(a -> {
                    AccountVO accountVO = accountVOMap.get(a.getAccountId());
                    if (accountVO != null) {
                        a.setAccountName(accountVO.getFullName() != null ? accountVO.getFullName() : accountVO.getName());
                        a.setPhoto(accountVO.getHeadPortrait());
                    }
                });
            }
        }
        return Response.ok(page);
    }

    @PostMapping("/deleted")
    @ApiOperation(value = "取消禁言名单")
    public Response deleted(@ApiParam("禁言id必填 ") @RequestBody PostsForbiddenAccountVo forbiddenAccount) {
        postsForbiddenAccountClient.deleted(forbiddenAccount);
        return Response.ok("取消成功！");
    }

    @ApiOperation(value = "判断当前用户是否被禁言")
    @GetMapping("/hasForbiddenByPostsId")
    public Response<Object> hasForbiddenByPostsId(@ApiParam("帖子id必填 ") @RequestParam("postsId") Long postsId) {
        return Response.ok(postsForbiddenAccountClient.hasForbiddenByPostsId(postsId));
    }
}
