package com.yizhi.application.international;


import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.tools.PageTools;
import com.yizhi.site.application.feign.InternationalClient;
import com.yizhi.site.application.vo.site.SiteLanguageVO;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;

/**
 * @description: 国际化
 * @author: lly
 * @date: 2020-9-3 17:39:51
 **/
@Log4j2
@Api(tags = "学员端—功能模块")
@RestController
@RequestMapping("/public/api/siteLanguage")
public class SiteLanguageController {


    @Autowired
    private InternationalClient internationalClient;


    @ApiOperation(value = "语言功能模块", notes = "语言功能模块")
    @GetMapping("/page")
    public Response getList(
            @RequestParam(name = "pageNo", required = true, defaultValue = "1") Integer pageNo,
            @RequestParam(name = "pageSize", required = true, defaultValue = "20") Integer pageSize,
            @RequestParam(name = "status", required = false) Integer status
    ) {
        try {
            Page<SiteLanguageVO> page = internationalClient.getList(pageNo, pageSize, status);
            return Response.ok(PageTools.versaPage(page));
        } catch (Exception e) {
            log.info("语言类列表异常：{}", e.getMessage());
            return Response.fail();
        }
    }

    @ApiOperation(value = "语言列表", notes = "语言列表")
    @GetMapping("/language/get")
    public Response<String> getLanguage(@RequestParam(name = "type", required = true) Integer type,
                                        @RequestParam(name = "languageCode", required = true) String languageCode) {
        if (Objects.isNull(languageCode) || languageCode.equalsIgnoreCase("null")) {
            //如果前端没有传code 则自动获取管理端配置的第一位
            Page<SiteLanguageVO> page = internationalClient.getList(1, 1, 1);
            List<SiteLanguageVO> records = page.getRecords();
            if (CollectionUtils.isNotEmpty(records)) {
                languageCode = records.get(0).getLanguageCode();
            }
            if (Objects.isNull(languageCode)) {
                languageCode = "zh_CN";
            }
        }
        HashMap<String, String> language = internationalClient.getLanguage(type, languageCode);
        return Response.ok(JSON.toJSON(language));
    }

}