package com.yizhi.application.protal.controller;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.feign.PortalThemeColorClients;
import com.yizhi.site.application.vo.domain.PortalThemeColorVo;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 门户主题色配置 前端控制器
 * </p>
 *
 * @author fulan123
 * @since 2020-08-12
 */
@Api(tags = "学员端 换肤设置")
@RestController
@RequestMapping("/api/portal/theme/color")
public class PortalThemeColorController {

    @Autowired
    private PortalThemeColorClients portalThemeColorClients;

    /**
     * 查找改站点终端类型设置的主题颜色
     * @param terminalType
     * @return
     */
    @GetMapping("/public/get")
    @ApiOperation(value = "根据指定的设备类型获取设置的主题配置信息", response = PortalThemeColorVo.class)
    public Response<PortalThemeColorVo> getThemeColorBySiteId(@ApiParam(name = "terminalType", value = "终端类型：1 后台管理端  ；2 PC端 ； 3 移动端; 不设置就是0: 通用")
                                                            @RequestParam(value = "terminalType",required = false, defaultValue = "0") Integer terminalType){
        RequestContext rt = ContextHolder.get();
        return Response.ok(portalThemeColorClients.getThemeColorBySiteId(rt.getCompanyId(),rt.getSiteId(),terminalType));
    }
}
