package com.yizhi.application.assignment.controller;


import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.course.utils.StuWorkUtil;
import com.yizhi.assignment.application.feign.ApiAssignmentExerciseBookClient;
import com.yizhi.assignment.application.vo.AssignmentStudentExerciseBookListVO;
import com.yizhi.assignment.application.vo.apivo.ApiAssignmentCommentVO;
import com.yizhi.assignment.application.vo.entity.AssignmentAnswerTipoff;
import com.yizhi.assignment.application.vo.entity.AssignmentComment;
import com.yizhi.core.application.cache.CacheNamespace;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.json.JsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;


import java.util.*;

/**
 * @ClassName AssignmentExpriceBookController
 * @Description TODO
 * @Author shengchenglong
 * @DATE 2019-10-22 11:15
 * @Version 1.0
 */
@Api("作业本--学员端")
@RestController
@RequestMapping("/api/assignment/exerciseBook")
@Log4j2
public class ApiAssignmentExerciseBookController {

    @Autowired
    private ApiAssignmentExerciseBookClient apiAssignmentExerciseBookClient;
    @Autowired
    private StuWorkUtil stuWorkUtil;
    @Autowired
    private RedisCache redisCache;

    @GetMapping("/page")
    @ApiOperation(value = "作业本列表(每个人对改作业提交的答案)", response = AssignmentStudentExerciseBookListVO.class)
    public Response<AssignmentStudentExerciseBookListVO> list(
            @ApiParam("作业id") @RequestParam("assignmentId") Long assignmentId,
            @ApiParam("要跳转的页数") @RequestParam(name = "pageNo", defaultValue = "1") int pageNo,
            @ApiParam("每页条数，默认：10") @RequestParam(name = "pageSize", defaultValue = "10") int pageSize) {
        try {
            Page<AssignmentStudentExerciseBookListVO> page = apiAssignmentExerciseBookClient.list(assignmentId, pageNo, pageSize);
            Map<String, Integer> pageMap = new HashMap<>();
            pageMap.put("pageNo", pageNo);
            pageMap.put("pageSize", pageSize);
            pageMap.put("pageTotal", page.getTotal());
            Response response = Response.ok(page.getRecords(), pageMap);
            return response;
        } catch (Exception e) {
            log.error(e);
            return Response.fail();
        }
    }

    @GetMapping("/thumbUp")
    @ApiOperation(value = "点赞(取消点赞)", response = Boolean.class)
    public Response<Boolean> thumbup(
            @ApiParam("作业答案id") @RequestParam("assignmentAnswerId") Long assignmentAnswerId,
            @ApiParam("true:点赞,false:取消点赞") @RequestParam("isThumbUp") boolean isThumbUp) {
        try {
            return Response.ok(apiAssignmentExerciseBookClient.thumbup(assignmentAnswerId, isThumbUp));
        } catch (Exception e) {
            log.error(e);
            return Response.fail();
        }
    }

    @GetMapping("/comment/page")
    @ApiOperation(value = "评论列表", response = ApiAssignmentCommentVO.class)
    public Response<ApiAssignmentCommentVO> commentPage(
            @ApiParam("作业答案id") @RequestParam("assignmentAnswerId") Long assignmentAnswerId,
            @ApiParam("要跳转的页数") @RequestParam(name = "pageNo", defaultValue = "1") int pageNo,
            @ApiParam("每页条数，默认：10") @RequestParam(name = "pageSize", defaultValue = "10") int pageSize
    ) {
        try {
            Page<ApiAssignmentCommentVO> page = apiAssignmentExerciseBookClient.commentPage(assignmentAnswerId, pageNo, pageSize);
            Map<String, Integer> pageMap = new HashMap<>();
            pageMap.put("pageNo", pageNo);
            pageMap.put("pageSize", pageSize);
            pageMap.put("pageTotal", page.getTotal());

            List<ApiAssignmentCommentVO> records = page.getRecords();
            if (!CollectionUtils.isEmpty(records)) {
                RequestContext context = ContextHolder.get();
                Long companyId = context.getCompanyId();
                Set<String> sensitiveWordList = new HashSet<>();
                String sensitiveValues = (String) redisCache.hget(CacheNamespace.REDIS_SENSITIVE_WORD_INFO, companyId.toString());
                if (sensitiveValues != null) {
                    sensitiveWordList = JsonUtil.json2Ojbect(sensitiveValues, Set.class);
                    System.out.println(sensitiveWordList.iterator().next());
                }
                for (ApiAssignmentCommentVO record : records) {
                    String word = stuWorkUtil.filterWord(record.getContent(), sensitiveWordList);
                    record.setContent(word);
                }
            }

            Response response = Response.ok(page.getRecords(), pageMap);
            return response;
        } catch (Exception e) {
            log.error(e);
            return Response.fail();
        }
    }

    @PostMapping("/comment/add")
    @ApiOperation(value = "进行评论", response = Boolean.class)
    public Response<Boolean> commentAdd(
            @ApiParam("assignmentAnswerId-必传,content-必传,parentId-是回复评论是再传")
            @RequestBody AssignmentComment comment) {
        try {
            return Response.ok(apiAssignmentExerciseBookClient.commentAdd(comment.getAssignmentAnswerId(), comment.getParentId(), comment.getContent()));
        } catch (Exception e) {
            log.error(e);
            return Response.fail();
        }
    }

    @PostMapping("/tipoff")
    @ApiOperation(value = "举报", response = Boolean.class)
    public Response<Boolean> tipoff(
            @ApiParam("assignmentAnswerId-必传,content-必传,imgUrl-可传")
            @RequestBody AssignmentAnswerTipoff record) {
        try {
            return Response.ok(apiAssignmentExerciseBookClient.tipoff(record));
        } catch (Exception e) {
            log.error(e);
            return Response.fail("4001", "举报字数不能超过100字");
        }
    }

}
