package com.yizhi.application.wechat.controller;

import com.alibaba.fastjson.JSON;
import com.yizhi.wechat.application.feign.WechatProviderClient;
import com.yizhi.wechat.application.utils.InMsgEntity;
import com.yizhi.wechat.application.vo.wechat.SuiteTicketVO;
import com.yizhi.wechat.application.vo.wechat.WechatProviderVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.Date;


/**
 * 微信供应商
 *
 * @author lilingye
 * @since2020-7-24
 */
@RestController
@Api(tags = "微信服务商")
@RequestMapping("/public/provider/")
public class WechatProviderController {

    private static final Logger LOGGER = LoggerFactory.getLogger(WechatProviderController.class);
    @Autowired
    private WechatProviderClient wechatProviderClient;


    /**
     * @param timestamp
     * @param nonce
     * @param echostr
     * @return
     */
    @ApiOperation(value = "微信服务商平台配置接口", notes = "微信服务商平台配置接口")
    @GetMapping(value = "/get")
    public String checkToken(@RequestParam(name = "msg_signature") String msg_signature,
                             @RequestParam(name = "timestamp") String timestamp,
                             @RequestParam(name = "nonce") String nonce,
                             @RequestParam(name = "echostr") String echostr
    ) {
        LOGGER.info("参数msg_signature：" + msg_signature);
        LOGGER.info("参数timestamp：" + timestamp);
        LOGGER.info("参数nonce：" + nonce);
        LOGGER.info("参数echostr：" + echostr);
        String sEchoStr = null;
        try {
            sEchoStr = wechatProviderClient.checkToken(msg_signature, timestamp, nonce, echostr);
            LOGGER.info("返回的参数：{}", sEchoStr);
        } catch (Exception e) {
            LOGGER.info("返回异常");
        }
        return sEchoStr;
    }

    /**
     * @param timestamp
     * @param nonce
     * @param echostr
     * @return
     */
    @ApiOperation(value = "微信服务商平台配置接口", notes = "微信服务商平台配置接口")
    @GetMapping(value = "/callBack")
    public String callBack(@RequestParam(name = "msg_signature") String msg_signature,
                           @RequestParam(name = "timestamp") String timestamp,
                           @RequestParam(name = "nonce") String nonce,
                           @RequestParam(name = "echostr") String echostr
    ) {
        LOGGER.info("参数msg_signature：" + msg_signature);
        LOGGER.info("参数timestamp：" + timestamp);
        LOGGER.info("参数nonce：" + nonce);
        LOGGER.info("参数echostr：" + echostr);
        String sEchoStr = null;
        try {
            sEchoStr = wechatProviderClient.callBack(msg_signature, timestamp, nonce, echostr);
            LOGGER.info("返回的参数：{}", sEchoStr);
        } catch (Exception e) {
            LOGGER.info("返回异常");
        }
        return sEchoStr;
    }


    @ApiOperation(value = "微信服务商平台配置接口", notes = "微信服务商平台配置接口")
    @PostMapping(value = "/handle")
    public Object handlerMessage(@RequestBody InMsgEntity msg,
                                 String msg_signature,
                                 String timestamp, String nonce) {


        LOGGER.info("参数msg_signature：{}", JSON.toJSON(msg));
        LOGGER.info("参数timestamp：" + timestamp);
        LOGGER.info("参数nonce：" + nonce);
        LOGGER.info("signature：" + msg_signature);
        Object sEncryptMsg = null;
        try {
            WechatProviderVO wechatProviderVO = new WechatProviderVO();
            wechatProviderVO.setMsg(msg);
            wechatProviderVO.setSignature(msg_signature);
            wechatProviderVO.setTimestamp(timestamp);
            wechatProviderVO.setNonce(nonce);
            LOGGER.info("传的参数：{}", JSON.toJSON(wechatProviderVO));

            sEncryptMsg = wechatProviderClient.handlerMessage(wechatProviderVO);
            LOGGER.info("返回的参数：{}", sEncryptMsg);
        } catch (Exception e) {
            LOGGER.info("返回异常");
        }
        return sEncryptMsg;

    }


    @RequestMapping(value = "/suite/receive", method = {RequestMethod.GET}, produces = {"application/xml;charset=UTF-8"})
    public Object instructCallBack(@RequestParam(name = "msg_signature") String msg_signature,
                                   @RequestParam(name = "timestamp") String timestamp,
                                   @RequestParam(name = "nonce") String nonce,
                                   @RequestParam(name = "echostr") String echostr
    ) {
        LOGGER.info("参数msg_signature：" + msg_signature);
        LOGGER.info("参数timestamp：" + timestamp);
        LOGGER.info("参数nonce：" + nonce);
        LOGGER.info("参数echostr：" + echostr);
        String sEchoStr = null;
        try {
            sEchoStr = wechatProviderClient.callBack(msg_signature, timestamp, nonce, echostr);
            LOGGER.info("返回的参数：{}", sEchoStr);
        } catch (Exception e) {
            LOGGER.info("返回异常");
        }
        return sEchoStr;
    }

    /**
     * 推送suite_ticket
     */
    @PostMapping(value = "/suite/receive", produces = {"application/xml;charset=UTF-8"})
    public Object suiteTicket(
            @RequestBody InMsgEntity inMsgEntity,
            @RequestParam(name = "msg_signature") String msg_signature,
            @RequestParam(name = "timestamp") String timestamp,
            @RequestParam(name = "nonce") String nonce) {


        SuiteTicketVO suiteTicketVO = new SuiteTicketVO();
        suiteTicketVO.setInMsgEntity(inMsgEntity);
        suiteTicketVO.setMsg_signature(msg_signature);
        suiteTicketVO.setTimestamp(timestamp);
        suiteTicketVO.setNonce(nonce);
        //设置日期格式
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        LOGGER.info("请求的时间：{}", df.format(new Date()));
        LOGGER.info("=====================================================");

        LOGGER.info("参数:{}", JSON.toJSON(inMsgEntity));
        String res = wechatProviderClient.suiteReceive(suiteTicketVO);

        return res;
    }
}